#include "config.h"

#ifndef _MAPPER_MAP_DOWNLOAD_H
#define _MAPPER_MAP_DOWNLOAD_H

#include <curl/multi.h>
#include <glib.h>
#include "mapper-types.h"
#include "map-repo.h"

#define INITIAL_DOWNLOAD_RETRIES (3)

/** The Source ID of the CURL Multi Download timeout. */
guint _curl_sid;

CURLM *_curl_multi;

void map_download_init(void);
void map_initiate_download(guint tilex, guint tiley, guint zoom, gint retries);
gboolean map_download_stop(void);
gboolean map_download_timeout(void);
void map_download_deinit(void);

#endif
