#!/bin/sh
#
# This little script builds an appropriately-versioned .deb file depending
# on IT OS give.
#
# OS2006
#  For 770 (-mcpu=arm926ej-s), the version is suffixed with "-OS2006".
#
# OS2007
#  For N800 and 770 (-mcpu=arm1136jf-s), the version is suffixed with "-OS2007".
# 
# OS2008
#  For N800 and N810, the version is suffixed with "-OS2008".

CHANGELOG=`dirname $0`/debian/changelog

case "$1" in
    maemo5)
    CFLAGS="-O2 -pipe -mcpu=cortex-a8"
    VERSION_SUFFIX=-m5
    cp debian/control.m5 debian/control
    ;;
    OS2008|maemo4)
    CFLAGS="-O2 -pipe -mcpu=arm1136jf-s"
    VERSION_SUFFIX=-OS2008
    cp debian/control.m4 debian/control
    ;;
    OS2007|maemo3)
    CFLAGS="-O2 -pipe -mcpu=arm926ej-s"
    VERSION_SUFFIX=-OS2007
    cp debian/control.m4 debian/control
    ;;
    OS2006|maemo2)
    CFLAGS="-O2 -pipe -mcpu=arm926ej-s"
    VERSION_SUFFIX=-OS2006
    cp debian/control.m2 debian/control
    ;;
    *)
    echo "Give one of OS2006, OS2007, OS2008 or maemo5 as parameter"
    exit 1
    ;;
esac

export CFLAGS

rm $CHANGELOG
head -n 1 $CHANGELOG.in | sed "s/)/$VERSION_SUFFIX)/" > $CHANGELOG
awk 'NR>1 {print}' $CHANGELOG.in >> $CHANGELOG

dpkg-buildpackage -rfakeroot -I.git
