/*
 * poi-layer.h - Header for Champlain POI layer
 * Copyright (C) 2010 Collabora Ltd
 * @author Cosimo Alfarano <cosimo.alfarano@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_BUDDY_POI_LAYER_H
#define MAP_BUDDY_POI_LAYER_H

#include <champlain/champlain.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_POI_LAYER     (map_buddy_poi_layer_get_type())
#define MAP_BUDDY_POI_LAYER(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), \
      MAP_BUDDY_TYPE_POI_LAYER, MapBuddyPoiLayer))
#define MAP_BUDDY_POI_LAYER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),  MAP_BUDDY_TYPE_POI_LAYER, \
                           MapBuddyPoiLayerClass))
#define MAP_BUDDY_IS_POI_LAYER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
      MAP_BUDDY_TYPE_POI_LAYER))
#define MAP_BUDDY_IS_POI_LAYER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),  MAP_BUDDY_TYPE_POI_LAYER))
#define MAP_BUDDY_POI_LAYER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj),  MAP_BUDDY_TYPE_POI_LAYER, \
                             MapBuddyPoiLayerClass))

typedef struct _MapBuddyPoiLayer MapBuddyPoiLayer;

typedef struct _MapBuddyPoiLayerClass MapBuddyPoiLayerClass;

GType map_buddy_poi_layer_get_type (void);

MapBuddyPoiLayer *map_buddy_poi_layer_new (void);

void map_buddy_poi_layer_start (MapBuddyPoiLayer *self,
    ChamplainLayer *champlain_layer, GtkWindow *main_window);

G_END_DECLS

#endif
