/***************************************************************************

Copyright 2010 Reto Zingg <g.d0b3rm4n@gmail.com>

***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/


#include "settingswidget.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QComboBox>
#include <QLabel>
#include <QPushButton>


SettingsWidget::SettingsWidget(QWidget *parent) :
    QWidget(parent)
{

    QVBoxLayout *vbox = new QVBoxLayout();

    QHBoxLayout *hbox_level = new QHBoxLayout();
    QHBoxLayout *hbox_game = new QHBoxLayout();
    QHBoxLayout *hbox_bottom = new QHBoxLayout();

    m_ComboLevel = new QComboBox();
    m_ComboLevel->addItem("Easy");
    m_ComboLevel->addItem("Medium");
    m_ComboLevel->addItem("Hard");

    connect(m_ComboLevel,
            SIGNAL(currentIndexChanged(int)),
            this,
            SIGNAL(levelChanged(int)));

    m_ComboGame = new QComboBox();

    connect(m_ComboGame,
            SIGNAL(currentIndexChanged(int)),
            this,
            SIGNAL(gameChanged(int)));

    QLabel *label_level = new QLabel(tr("Level:"));
    hbox_level->addWidget(label_level);
    hbox_level->addWidget(m_ComboLevel);

    QLabel *label_game = new QLabel(tr("Game:"));
    hbox_game->addWidget(label_game);
    hbox_game->addWidget(m_ComboGame);

    QPushButton *m_button = new QPushButton();
    m_button->setText(tr("Start"));
    hbox_bottom->addWidget(m_button);

    connect(m_button,
            SIGNAL(clicked()),
            this,
            SIGNAL(start()));

    vbox->addLayout(hbox_level);
    vbox->addLayout(hbox_game);
    vbox->addLayout(hbox_bottom);

    setLayout(vbox);

}

void SettingsWidget::setGameNames(QStringList gameNames){
    m_ComboGame->addItems(gameNames);
}
