/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef BOARD_H
#define BOARD_H

#include <QtSvg/QGraphicsSvgItem>
#include <QList>

class Cup;
class Kalah;
class Stone;
class GameInfo;
class ThemeManager;

class Board : public QGraphicsSvgItem{
    Q_OBJECT
public:

    Board(GameInfo *manager, ThemeManager *theme);
    ~Board();

    void manipulateStones(QList<Stone*>& currentStoneList);
    void updateChildren(int cupIndex,QList<Stone*> &currentStoneList);

    void updateChildren(int,int,bool);
    void updateChildren(int,int,int);

    void initialSetup();

    int findCupIndex(QPointF);

public slots:
    void slotUpdateChildren();

protected:
    QPointF calcCupPosition(int row, int col);

private:
    void createKalahs();
    void createCups();
    void showGameName();

    QList <Cup*> m_cups;
    QList <Stone*> m_stones;
    Kalah* m_rightKalah;
    Kalah* m_leftKalah;

    GameInfo *m_gameInfo;
    ThemeManager *m_theme;

    qreal gapWidth;

    bool m_isCup;
    int m_index;
    Stone* m_stone;
};

#endif // BOARD_H
