/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GRAPHICSSCENE_H
#define GRAPHICSSCENE_H

#include <QGraphicsScene>
#include <QWheelEvent>
#include <QPixmap>
#include <QPixmapCache>
#include <qmath.h>


class GameInfo;
class ThemeManager;
class Board;
class GameController;
class Stone;
class QWidget;
class MainWindow;
class QGraphicsSvgItem;

class GraphicsScene : public QGraphicsScene{
    Q_OBJECT

public:
    GraphicsScene( GameInfo* ,ThemeManager* , GameController* , QWidget* parent = 0);
    QPixmap renderBackground(const QSize& size,bool newGame);

signals:
    void signalMouseClicked(int);

public slots:
    void slotStartGame();


private:

    QGraphicsSvgItem *m_gameName;
    GameInfo* m_gameInfo;
    GameController* m_gameController;
    ThemeManager* m_gameTheme;
    Board* m_board;
    QList<Stone*> m_stones;
    MainWindow* m_parent;

    void setupGameNecessaries();
    void deleteGameNecessaries();

    void showGameName();
    virtual void mousePressEvent ( QGraphicsSceneMouseEvent * mouseEvent );
    virtual void drawBackground( QPainter* painter,const QRectF &rect);
};

#endif // GRAPHICSSCENE_H
