/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CUP_H
#define CUP_H

#include <QtSvg/QGraphicsSvgItem>
#include <QGraphicsSimpleTextItem>

class QSizeF;
class Board;
class Stone;
class QPainter;
class GameInfo;

class Cup : public QGraphicsSvgItem{
    Q_OBJECT
    public:
        Cup(GameInfo* info, int cupNumber, QGraphicsSvgItem *parent);

        void drawInitially();
        void drawTextInitially(int numStone);
        void updateStoneList(Stone* stoneItem);
        Stone* updateStoneList();
        QPointF* calculateStonePosition(Stone *stone);
        void addStone(Stone* stone);

        //void setIdentifier(int num){ m_identifier = num;}
        void setPosition(QPointF pos){ m_pos = pos;}
        void setSize(QSizeF size){ m_size = size;}

        //getting methods
        int index() const{ return m_index; }
        QSizeF size() const{ return m_size;}
        QPointF middlePoint() const{ return m_mid_point;}
        QPointF position() const{return m_pos;}
        QPainterPath shape() const;

    signals:

    public slots:
        void slotChangeText();

    private:
        //int m_identifier; //only for debugging

        QPointF m_pos;
        QSizeF m_size;
        QPointF m_mid_point;
        int m_index;
        QString m_stone_num;

        QList <Stone*> m_stone;
        QGraphicsSimpleTextItem *m_text;

        GameInfo* m_gameInfo;
        Board* m_board;
    };

#endif // CUP_H

