/*
* This file is part of Mancala
*
* Originally from Crazyparking:
* Copyright (C) 2005 INdT - Instituto Nokia de Tecnologia
* http://www.indt.org/maemo
*
* adapted:
* Copyright (c) 2009 Reto Zingg
*
* Some of the code is based on the examples on:
* http://wiki.maemo.org/Documentation/Maemo_5_Developer_Guide
*
* This software is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*
*/ 


#include <stdio.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>
#include <startup_app.h>
#include <dbus/dbus-glib.h>


static GtkWidget *load_plugin               (void);
static void       unload_plugin             (void);
static void       write_config              (void);

static GameStartupInfo gs;

static StartupPluginInfo plugin_info = {
  load_plugin,
  unload_plugin,
  write_config,
  NULL
};




STARTUP_INIT_PLUGIN(plugin_info, gs, FALSE, FALSE)

// the following does not work proper until osso_game_startup is
// implemented as stackable window...

// static void destroy_help_subwindow (void)
// {
//     StartupApp *app = gs.ui->app;
//     osso_application_top(app->osso, app->path, NULL);
// }
// 
// static void show_help_subwindow (void)
// {
//     GtkWidget *win;
//     GtkWidget *textbox;
//     GtkTextBuffer *textbox_buffer;
//     gchar *textbox_text;
//     PangoFontDescription *font_desc;
//     GtkWidget *pannable_text;
//     
//     /* Create the subwindow (a stackable window) */
//     win = hildon_stackable_window_new();
//     gtk_window_set_title ( GTK_WINDOW (win), "Help");
// 
//     /* Create and pack labels */     
//     textbox_text = g_strdup_printf("Welcome to Mancala, the ancient African game of skill!\n\nMancala is a very simple, easy-to-learn game. Each player begins with a horizontal row of holes or pits filled with a certain number of stones. At either end of the board are the players' home pits, which are used to keep score. In this case, the human player has the left home pit and the upper row holes. A move is made by clicking into the hole you wish to move from. The stones are then picked up and distributed, one to each hole, moving toward your home pit is reached, and then moving through your opponent's row, bypassing his/her home, and moving back towards in a circle (counterclockwise), until all the stones have been distributed.\n\nIf the last stone is placed in your home, you receive an extra turn. If the last stone lands in an empty hole on your side, you 'capture' the stones in the opposite hole on your opponent's side, moving them to your home.\n\nThe game ends when one player cannot play (ie. there are no stones on his/her side of the board.  The player who has the most stones on his/her *side* wins.");
//     
//     textbox = hildon_text_view_new();
//     gtk_text_view_set_editable(GTK_TEXT_VIEW(textbox), FALSE);
//     // gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(textbox), FALSE);
//     gtk_text_view_set_indent(GTK_TEXT_VIEW(textbox), 10);
//     gtk_text_view_set_left_margin(GTK_TEXT_VIEW(textbox), 10);
//     gtk_text_view_set_right_margin(GTK_TEXT_VIEW(textbox), 10);
//     gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(textbox), 3);
//     gtk_text_view_set_pixels_below_lines(GTK_TEXT_VIEW(textbox), 2);
//     gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textbox), GTK_WRAP_WORD);
//     // gtk_widget_set_sensitive(textbox, FALSE);
//     font_desc = pango_font_description_from_string ("vera 18");
//     gtk_widget_modify_font(textbox, font_desc);
//     pango_font_description_free (font_desc);
//     
//     textbox_buffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (textbox));
//     
//     gtk_text_buffer_set_text(textbox_buffer, textbox_text, -1);
//     
//     
//     pannable_text = hildon_pannable_area_new();
//     hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA(pannable_text), textbox);
//     
//     gtk_container_add (GTK_CONTAINER (win), pannable_text);
//     
//     g_signal_connect (win, "destroy",    destroy_help_subwindow, NULL);
//     
// 
//     /* This call show the window and also add the window to the stack */
//     gtk_widget_show_all (win);
// }


static void show_help_browser (void)
{
    char *uri = "file:///home/opt/mancala/data/mancala.html";
    DBusGConnection *connection;
    GError *error = NULL;
    DBusGProxy *proxy;
    
    connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
    
    if (connection == NULL){
        printf("Dbus connection failed: %s\n",error->message);
        g_error_free (error);
        return;
    }
    
    proxy = dbus_g_proxy_new_for_name (connection,
                                       "com.nokia.osso_browser",
                                       "/com/nokia/osso_browser/request",
                                       "com.nokia.osso_browser");

    error = NULL;

    if (!dbus_g_proxy_call (proxy, "load_url", &error, G_TYPE_STRING, uri, G_TYPE_INVALID, G_TYPE_INVALID)){
        printf("Load_URL failed: %s\n",error->message);
        g_error_free (error);
    }

}


static GtkWidget *load_plugin (void)
{
    GtkWidget *button;
    button =  gtk_button_new_with_label ("Instuctions");
    
    g_signal_connect (button, "clicked", G_CALLBACK (show_help_browser), NULL);
    
    return GTK_WIDGET(button);
    
}

static void
unload_plugin (void)
{

}

static void
write_config (void)
{
  
}


