/*
*  for Maemo renamed to play.c and some bugfixes (2009, Reto Zingg)
*
*  Main Mancala Program Module Source -- main.c 
*  $Id: main.c,v 1.7.2.25 2004/01/17 06:56:23 sparrow_hawk Exp $
*
*  Copyright (C) 2003 Kevin Riggle 
*  http://cmancala.sourcefoge.net
*  Copyright (C) 2009 Reto Zingg
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2, or (at your option) any
*  later version.
*
*  This program is distributed in the hope that it will be useful, but
*  WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  General Public License for more details, a copy of which may be found in
*  the file COPYING provided in the main directory of this release.
*
*/

#include <hildon/hildon.h>
#include <hgw/hgw.h>
#include <unistd.h>

#include "SDL_mixer.h"
#include "SDL.h"
#include "SDL_image.h"
#include "SDL_ttf.h"
#include "SDL_getenv.h"

#include "graphics.h"
#include "mancala.h"
#include "ai.h"
#include "sounds.h"
#include "play.h"

#include "callbacks.h"

// the surfaces
SDL_Surface *screen, *board, *title_text, *tile, *stone[STONE_MAX+1], *exit_text;
// the fonts
TTF_Font *title_font, *home_font, *board_font;
// The sound effects that will be used
Mix_Chunk *pick = NULL;
// the hildon-game-wrapper context
HgwContext *hgw_context = NULL;

// for debugging, example:

// rmz_debug(g_strdup_printf("play step 2: SDL_AUDIODRIVER: %s",
//                            my_sdl_audiodrv)
//                          );

// void rmz_debug (char *msg){
//     FILE *pFile;
//     
//     pFile = fopen ("/home/rzingg/mancala.debug", "a");
//     if (pFile) {
//         fprintf (pFile, "rmz_debug: %s \n", msg);
//         fclose (pFile);
//     }
// }

void sdl_clean_up(){
        
        int i = 0;
        
        SDL_FreeSurface(board);
        SDL_FreeSurface(tile);
        SDL_FreeSurface(exit_text);
        SDL_FreeSurface(title_text);
        for(i=0; i<=STONE_MAX; i++)
                SDL_FreeSurface(stone[i]);
        SDL_FreeSurface(screen);
        TTF_CloseFont(title_font);
        TTF_CloseFont(board_font);
        TTF_CloseFont(home_font);
        Mix_FreeChunk(pick);
        /* Make sure we clean up after ourselves */
        TTF_Quit();
        Mix_CloseAudio();
        SDL_Quit();
        return;
}

int play() {

        // Scratchbox needs different SDL_AudiDriver env
        #if __i386__
        putenv("SDL_AUDIODRIVER=alsa") ;
        #endif /* __i386__ */
        
        SDL_Rect board_rect, title_rect, exit_rect;
        SDL_Color font_color;
        SDL_Event event;
        SDL_Color font_color_exit;
        
        char tile_path[STRING_MAX], stone_path[STRING_MAX];
        char icon_path[STRING_MAX], title_path[STRING_MAX];
        char home_path[STRING_MAX], board_path[STRING_MAX];
        char pick_path[STRING_MAX];
        int aiBoard[BOARD_MAX+1], humanBoard[BOARD_MAX+1];
        int i, redraw_board, highlight, old_highlight, active;
        int current_move, ai_last_move, human_last_move, state;
        
        /* Set up the game board and game variables. */
        gameInit(aiBoard, humanBoard);
        current_move = 0;
        ai_last_move = human_last_move = -99;
        
        /* initialize our libraries */
        //if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER|SDL_INIT_AUDIO) < 0) {
       if (SDL_Init(SDL_INIT_EVERYTHING) < 0) {
               printf("Unable to initialize SDL: %s\n", 
                        SDL_GetError());
                        sdl_clean_up();
                        return 1;
       }
       
       if (TTF_Init() < 0) {
               printf("Unable to initialize SDL_ttf: %s\n", 
                        SDL_GetError());
                        sdl_clean_up();
                        return 1;
       }
       
       //Initialize SDL_mixer 
       if( Mix_OpenAudio( 22050, MIX_DEFAULT_FORMAT, 2, 4096 ) == -1 ) 
       // if( Mix_OpenAudio(22050, (Uint16)AUDIO_U8, 2, 256 ) == -1 )
       {
               printf("Unable to initialize Mix_OpenAudio: %s\n",
                        SDL_GetError());
                        sdl_clean_up();
                        return 1;
       }
       
       /* Load our images... PNGs now, maybe XPMs later */
       sprintf(tile_path, "%s/tile.png", RES_PATH);
       if ((tile = LoadRes(tile_path)) == NULL) {
               printf("Unable to load resource: %s\n", 
                        SDL_GetError());
                        sdl_clean_up();
                        return 1;
       }
       
       for (i=0; i<=STONE_MAX; i++) {
               if (sprintf(stone_path, "%s/stone%02d.png", RES_PATH, i) == 0)
                       printf("Problems assembling path.\n");
               if (!(stone[i] = LoadRes(stone_path))) {
                       printf("Unable to load resource: %s\n",
                                SDL_GetError());
                                sdl_clean_up();
                                return 1;
               }
       }
       
       /* Load our font(s) */
       if (sprintf(title_path, "%s/luxisr.ttf", FONT_PATH) == 0)
               printf("Problems assembling path.\n");
       if (!(title_font = TTF_OpenFont(title_path, TITLE_SIZE))) {
               printf("Could not load font: %s\n", TTF_GetError());
               sdl_clean_up();
               return 1;
       }
       
       if (sprintf(board_path, "%s/luxisr.ttf", FONT_PATH) == 0)
               printf("Problems assembling path.\n");
       if (!(board_font = TTF_OpenFont(board_path, BOARD_SIZE))) {
               printf("Could not load font: %s\n", TTF_GetError());
               sdl_clean_up();
               return 1;
       }
       
       if (sprintf(home_path, "%s/luxisr.ttf", FONT_PATH) == 0)
               printf("Problems assembling path.\n");
       if (!(home_font = TTF_OpenFont(home_path, HOME_SIZE))) {
               printf("Could not load font: %s\n", TTF_GetError());
               sdl_clean_up();
               return 1;
       }
       
       /* Load sound effects */ 
       sprintf(pick_path, "%s/pick.wav", RES_PATH); 
       if ((pick = Mix_LoadWAV(pick_path)) == NULL) { 
               printf("Unable to load sound: %s\n", 
                        SDL_GetError());
                        sdl_clean_up();
                        return 1; 
       }
       
       /* store the font's color */
       font_color.r = 255;
       font_color.b = 255;
       font_color.g = 255;
       
       /* render the title text 
       if (!(title_text = TTF_RenderText_Solid(title_font, 
               "Mancala", font_color))) 
               fprintf(stderr, "TTF: %s\n", TTF_GetError());
       */
       title_text = NULL;
       
       
       /* define the position of the board in the screen */
       board_rect.x = 0;
       board_rect.y = Y_OFFSET;
       board_rect.w = 0;
       board_rect.h = 0;
       
       /* set window properties and create it */
       // SDL_WM_SetCaption("Mancala", "Mancala");
       // if (sprintf(icon_path, "%s/icon.png", RES_PATH) == 0)
       //        printf("Problems assembling icon path.\n");
       // SDL_WM_SetIcon(LoadRes(icon_path), NULL);
       if ((screen = SDL_SetVideoMode(tile->w*8, (tile->h*2) + Y_OFFSET, 16, SDL_FULLSCREEN))
               == NULL) {
               printf("Unable to set %dx%d video: %s", tile->w*8,
                        tile->h*2, SDL_GetError());
                        sdl_clean_up();
                        return 1;
       }
       SDL_ShowCursor(SDL_DISABLE);
       
       /* define the font color fot the exit text */
       font_color_exit.r = 255;
       font_color_exit.r = 255;
       font_color_exit.r = 255;
       
       if (!(exit_text = TTF_RenderText_Blended(home_font, "EXIT", 
             font_color_exit))) {
                     printf("SDL_ttf: %s\n", TTF_GetError());
                     return 1;
        }
       
        exit_rect.x = 400;
        exit_rect.y = 0;
        exit_rect.w = 0;
        exit_rect.h = 0;
        
        SDL_BlitSurface(exit_text, NULL, screen, &exit_rect);
        
       state = HMN_WAIT;
       redraw_board = 1;
       old_highlight = 0;      
       highlight = 0;
       active = 0;
       
       /* GAME LOOP */
       while (state != GAME_WON) {
               
               /* check for GTK events... */
               /* otherwise hildon thinks the app hangs... */
               while (gtk_events_pending ())
                       gtk_main_iteration ();
               
               /* figure out if anything important happened */
               old_highlight = highlight;
               while (SDL_PollEvent(&event)) {
                       /* BAIL OUT! BAIL OUT! */
                       if (event.type == SDL_KEYDOWN){
                               printf("event SDL_KEYDOWN found....\n");
                               if ( event.key.keysym.sym == SDLK_q )
                               {
                                       printf("event SDLK_q found....\n");
                                       SDL_Event quit_event;
                                       quit_event.type = SDL_QUIT;
                                       SDL_PushEvent(&quit_event);
                               }
                       }
                       
                       if (event.type == SDL_MOUSEBUTTONDOWN) {
                               if ((event.button.button = 1) &&
                                   (event.button.y < Y_OFFSET)) {
                                       printf("clicked out side the board in exit area...\n");
                                       SDL_Event quit_event;
                                       quit_event.type = SDL_QUIT;
                                       SDL_PushEvent(&quit_event);
                               }
                       }
                       
                       if (event.type == SDL_QUIT) {
                               printf("event SDL_QUIT found....\n");
                               sdl_clean_up();
                               return 0;
                       }
                       
                       /* get events */
                       if (state == HMN_WAIT) {
                               switch (event.type) {
                                       case SDL_MOUSEBUTTONDOWN:
                                               if ((event.button.button = 1) &&
                                                   (event.button.y < tile->h) &&
                                                   (event.button.y > Y_OFFSET)) {

                                                       int pitch=0;
                                                       pitch = event.button.x / tile->w;

                                                        // pitch 0 and 7 are the homebases which you can't play
                                                        if ( pitch == 0 || pitch == 7 ){
                                                                 printf("clicked out side the board...\n");
                                                        }
                                                        else{
                                                                current_move = pitch;
                                                                state = HMN_MOVE;
                                                        }
                                               }
                                               break;
                                       case SDL_MOUSEMOTION:
                                               if (event.motion.y < tile->h) {
                                                       highlight = event.motion.x / tile->w;
                                               }
                                               else
                                                       highlight = 0;
                                               break;
                                       case SDL_ACTIVEEVENT:
                                               if (event.active.gain == 0)
                                                       highlight = 0;
                                               break;
                               }
                       }
               }
               SDL_Delay(DELAY_MAX);
               
               /* GAME LOGIC */
               if (gameWon(aiBoard, humanBoard) == 1)
                       state = GAME_WON;
               
               /* happy happy state machine */
               switch(state) {
                       case HMN_WAIT:
                               active = 0;
                               if (highlight != old_highlight)
                                       redraw_board = 1;
                               break;
                       case HMN_MOVE:
                               human_last_move = move(humanBoard,aiBoard,current_move);
                               play_sound(pick);
                               redraw_board = 1;
                               if (human_last_move == 0)
                                       state = HMN_WAIT;
                               else 
                                       state = CMP_WAIT;
                               printf("Human moving from %d to %d, now %d\n", current_move, human_last_move, state);
                               break;
                       case CMP_WAIT:
                               SDL_Delay(DELAY_AI);
                               active = 1;
                               current_move = aiMove(aiBoard, humanBoard);
                               state = CMP_MOVE;
                               break;
                       case CMP_MOVE:
                               printf("Computer moving\n");
                               ai_last_move = move(aiBoard,humanBoard,current_move);
                               play_sound(pick);
                               redraw_board = 1;
                               if (ai_last_move == 0)
                                       state = CMP_WAIT;
                               else
                                       state = HMN_WAIT;
                               break;
                       case GAME_WON:
                               if (aiBoard[0] > humanBoard[0]) {
                                       if (!(title_text = TTF_RenderText_Blended(title_font, 
                                               "Computer Wins!", font_color)))
                                               printf("TTF: %s\n", TTF_GetError());
                               }
                               else {
                                       if (!(title_text = TTF_RenderText_Blended(title_font, 
                                               "Human Wins!", font_color))) 
                                               printf("TTF: %s\n", TTF_GetError());
                               }
                               redraw_board = 1;
                               break;
               }
               
               /* redraw the board if needed */
               if (redraw_board == 1) {
                       /*printf("redrawing board\n");*/
                       
                       /* draw and blit the board */
                       board = DrawBoard(aiBoard, humanBoard, board_font, 
                                          home_font, tile, stone, active, 
                                          highlight);
                                          if (!board) {
                                                  printf("Could not draw the board.\n");
                                          }
                                          else {
                                                  // board_rect = SurfaceToRect(board);
                                                  SDL_BlitSurface(board, NULL, screen, 
                                                                   &board_rect);
                                          }
                                          
                                          /* draw, center, and blit the title */
                                          if (title_text) {
                                                  title_rect = SurfaceToRect(title_text);
                                                  title_rect.x = ((screen->w - title_rect.w)/2);
                                                  title_rect.y = ((screen->h - title_rect.h)/2);
                                                  SDL_BlitSurface(title_text, NULL, screen, 
                                                                   &title_rect);
                                          }
                                          
                                          SDL_UpdateRect(screen, 0,0,0,0);
                                          
                                          redraw_board = 0;
               }
               
               hgw_msg_compat_receive(hgw_context, 0);
               
       }
       
       SDL_Delay(DELAY_AI);
       
       
       sdl_clean_up();
       return 0;
       
}


int main(int argc, char **argv) {

    hgw_context = hgw_context_compat_init(argc, argv);
    if (!hgw_context) {
        printf("Cannot init hildon-games-startup!\n");
        return 0;
    }

    hgw_compat_set_cb_exit(hgw_context, exit_callback);
    hgw_compat_set_cb_quit(hgw_context, quit_callback);
    hgw_compat_set_cb_flush(hgw_context, flush_callback);    
    if(!hgw_context_compat_check(hgw_context)) return 0;

    /* hildon-games-wrapper part */
    hgw_msg_compat_receive(hgw_context, 0);
    usleep(100);

    // Main game
    play();

    // hgw_context_compat_destroy_deinit(hgw_context);
    // hgw_context_compat_destroy_quit(hgw_context);
    // hgw_context_destroy(hgw_context);
    hgw_context_destroy(hgw_context, HGW_BYE_INACTIVE);

    return 0;
}

