/*  
 *  AI Initialization Routine -- ai-init.c
 *  Kevin Riggle
 *  http://cmancala.sourceforge.net
 *  $Source: /cvsroot/cmancala/mancala/src/Attic/ai-init.c,v $
 *  $Revision: 1.3.2.1 $
 *  $Date: 2003/12/29 05:49:52 $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "mancala.h"
#include "ai-init.h"

/* Initialize everything needed by the ai function */

int aiInit(
	int *aiBoard, int *humanBoard, char *filename, 
	int (*aifunc)(int *aiBoard, int *humanBoard, int depth, FILE *log)
) {

	int aiBoardTemp[BOARD_MAX+1], humanBoardTemp[BOARD_MAX+1];
	int bestmove, k;
	FILE *log;

	/* open a log file */
	if ((log = fopen(filename, "w")) == NULL) {
		printf("Cannot open %s...\n", filename);
		return 1; 
	}

	/* make a temporary copy of the boards */
	for (k=0; k<=BOARD_MAX; k++) {
		aiBoardTemp[k] = aiBoard[k];
		humanBoardTemp[k] = humanBoard[k];
	}

	/* call the function in question */
	bestmove = (*aifunc)(aiBoardTemp, humanBoardTemp, 0, log);

	/* clean up and return the best move */
	fflush(log);
	fclose(log);

	return bestmove;

}

/* End ai-init.c */
