# -*- coding: utf-8 -*-

###########################################################################
#    Maevies
#    Copyright (C) 2010 Simón Pena <spenap@gmail.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

import os
import sys

APP_NAME = 'Maevies'
APP_COMPACT_NAME = 'maevies'
APP_VERSION = '0.2'
APP_DESCRIPTION = '%(app_name)s is a movie advisory application' % {'app_name': APP_NAME}
APP_URL = 'http://simonpena.com'
APP_COPYRIGHT = 'Copyright © 2010-2011 Simón Pena'
APP_AUTHORS = ['Simón Pena <spenap@gmail.com>']
APP_LICENSE = \
"""%(app_name)s is free software: you can redistribute it and/or modify \
it under the terms of the GNU General Public License as published by \
the Free Software Foundation, either version 3 of the License, or \
(at your option) any later version.

%(app_name)s is distributed in the hope that it will be useful, \
but WITHOUT ANY WARRANTY; without even the implied warranty of \
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \
GNU General Public License for more details.

You should have received a copy of the GNU General Public License \
along with %(app_name)s.  If not, see <http://www.gnu.org/licenses/>.
""" % {'app_name': APP_NAME}
ICON_FOLDER = 'share/icons/hicolor/scalable/apps'
APP_ICON = os.path.join(sys.prefix, ICON_FOLDER, APP_COMPACT_NAME + '.png')
HOME = os.path.expanduser('~')
MVS_CONF_FOLDER = os.path.join(HOME,
                               '.osso',
                               APP_NAME.lower())
MVS_FAVORITES_FILE = os.path.join(MVS_CONF_FOLDER, 'favorites.db')
TIMEOUT_TIME_MILLIS = 1000
LEFT_ALIGNMENT = 0
CENTER_ALIGNMENT = 0.5
MVS_CACHE = os.path.join(HOME,
                         '.cache',
                         APP_NAME.lower())
if not os.path.exists(MVS_CACHE):
    os.makedirs(MVS_CACHE, 0700)
if not os.path.exists(MVS_CONF_FOLDER):
    os.makedirs(MVS_CONF_FOLDER)
DBUS_ERROR = 'Unable to connect to backend'
