# -*- coding: utf-8 -*-
"""
Module implementing MainWindow.
"""
from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect, Qt
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView, QPixmap, QImage, QGraphicsPixmapItem
from pygame import mixer, init as pginit, error as pgerror, get_error as pgget_error
#import time
#This is the Pygame version for Audio
from Ui_sound import Ui_MainWindow
from configstub import configWindow
from beatstub import beatWindow
import sys
    
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
        FREQ = 48000   # play with this for best sound
        BITSIZE = -16  # here unsigned 16 bit
        CHANNELS = 2   # 1 is mono, 2 is stereo, not the same as playbackchannels
        BUFFER = 1024 # audio buffer size, number of samples
        
        #myRecorder=audioRecorder(self)

        mixer.pre_init(FREQ, BITSIZE, CHANNELS, BUFFER)
        pginit()
        mixer.set_num_channels(50)
        self.soundAArray=[]
        self.soundBArray=[]
        self.chanArray=[]
        self.beatChan=[]
        self.tempo=20
        self.bpm=0
        self.decay=500
        self.sustain=0
        self.vol=0.5
        self.vibra=0
        self.organ=0
        self.voice=0
        self.loadSamples()
        self.initChannels()
        self.initBeatChannels()
        self.key=[]

        for c in range(20):
            self.key.append(QGraphicsPixmapItem())
    
        #Build the Keyboard using QGraphicsView
        self.buttonid=0
        self.scene = QGraphicsScene()
        self.sceneWidth=800
        self.sceneHeight=400
        self.centerx=0
        self.centery=0
        self.svgRect=QRect()
        
        pixmap1 = QPixmap(100, 400)
        pixmap1.load("/home/opt/maesynth/images/key1.png")
        pixmap2 = QPixmap(100, 400)
        pixmap2.load("/home/opt/maesynth/images/key2.png")
        pixmap3 = QPixmap(100, 400)
        pixmap3.load("/home/opt/maesynth/images/key3.png")
        pixmap4 = QPixmap(100, 400)
        pixmap4.load("/home/opt/maesynth/images/key4.png")
        pixmap5 = QPixmap(100, 400)
        pixmap5.load("/home/opt/maesynth/images/key5.png")
        pixmap6 = QPixmap(56, 223)
        pixmap6.load("/home/opt/maesynth/images/bkey1.png")
        pixmap7 = QPixmap(56, 223)
        pixmap7.load("/home/opt/maesynth/images/bkey2.png")
        pixmap8 = QPixmap(56, 223)
        pixmap8.load("/home/opt/maesynth/images/bkey3.png")
        pixmap9 = QPixmap(56, 223)
        pixmap9.load("/home/opt/maesynth/images/bkey4.png")
        pixmap10 = QPixmap(56, 223)
        pixmap10.load("/home/opt/maesynth/images/bkey5.png")
        pixmap11 = QPixmap(56, 223)
        pixmap11.load("/home/opt/maesynth/images/bkey6.png")
        
        
        
      
        self.key[1].setPixmap(pixmap1)
        self.key[1].setPos(0, 0)
        self.scene.addItem(self.key[1])
        
        self.key[2].setPixmap(pixmap2)
        self.key[2].setPos(100, 0)
        self.scene.addItem(self.key[2])
        
        self.key[3].setPixmap(pixmap3)
        self.key[3].setPos(200, 0)
        self.scene.addItem(self.key[3])
        
        self.key[4].setPixmap(pixmap1)
        self.key[4].setPos(300, 0)
        self.scene.addItem(self.key[4])
        
        self.key[5].setPixmap(pixmap4)
        self.key[5].setPos(400, 0)
        self.scene.addItem(self.key[5])
        
        self.key[6].setPixmap(pixmap5)
        self.key[6].setPos(500, 0)
        self.scene.addItem(self.key[6])
        
        self.key[7].setPixmap(pixmap3)
        self.key[7].setPos(600, 0)
        self.scene.addItem(self.key[7])
        
        
        self.key[8].setPixmap(pixmap1)
        self.key[8].setPos(700, 0)
        self.scene.addItem(self.key[8])
        
        self.key[9].setPixmap(pixmap6)
        self.key[9].setPos(58, 0)
        self.scene.addItem(self.key[9])
        
        self.key[10].setPixmap(pixmap7)
        self.key[10].setPos(183, 0)
        self.scene.addItem(self.key[10])
        
        self.key[11].setPixmap(pixmap8)
        self.key[11].setPos(359, 0)
        self.scene.addItem(self.key[11])
        
        self.key[12].setPixmap(pixmap9)
        self.key[12].setPos(473, 0)
        self.scene.addItem(self.key[12])
        
        self.key[13].setPixmap(pixmap10)
        self.key[13].setPos(584, 0)
        self.scene.addItem(self.key[13])
        
        self.key[14].setPixmap(pixmap11)
        self.key[14].setPos(760, 0)
        self.scene.addItem(self.key[14])

        #self.image=QPixmap.load ("keyup.png", 0)
        
       #self.centerx=self.sceneWidth/2
        #self.centery=self.sceneHeight/2
        #self.grView.centerOn(self.centerx, self.centery)
        #self.grView.scale(1, 1)
     
        self.grView.setScene(self.scene)
        self.connectShort()
        #self.beatTimer = QBasicTimer()
        #self.beatTimer.start(1000, self)
        self.beatIndex=1
        self.loadBSamples()
        self.loadSamples()
        
        self.configWin=configWindow(self)
        self.beatWin=beatWindow(self.configWin)
        try :
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
            self.configWin.setAttribute(Qt.WA_Maemo5StackedWindow )
            self.beatWin.setAttribute(Qt.WA_Maemo5StackedWindow )
            USE_MAEMO=True
        except:
            USE_MAEMO=False

            
        self.connect(self.configWin, SIGNAL("window closed"), self.config_window_closed)
        self.connect(self.configWin, SIGNAL("voice changed"),self.voiceChanged, self.voice)
        self.connect(self.configWin, SIGNAL("drum1 changed"),self.beatWin.drum1VolChanged)
        self.connect(self.configWin, SIGNAL("drum2 changed"),self.beatWin.drum2VolChanged)
        self.connect(self.configWin, SIGNAL("drum3 changed"),self.beatWin.drum3VolChanged)
        self.connect(self.configWin, SIGNAL("drum4 changed"),self.beatWin.drum4VolChanged)
        self.connect(self.configWin, SIGNAL("drum5 changed"),self.beatWin.drum5VolChanged)

        
    def keyEnteredShort(self, buttonid):
        """
        plays note with no repeat eg piano 
        """
        self.key[buttonid].hide()
        self.chanArray[buttonid].set_volume(self.vol)
        self.chanArray[buttonid].play(self.soundAArray[buttonid])
        self.chanArray[buttonid].fadeout(self.decay)
        #print "key entered short"
        
    def keyExitShort(self, buttonid):
        self.key[buttonid].show()
            
    def keyReleasedShort(self, buttonid):
        self.key[buttonid].show()

        
    def keyEnteredLong(self, buttonid):
        """
        plays note with repeat eg violin
        """
        self.key[buttonid].hide()
        self.chanArray[buttonid].set_volume(self.vol)
        self.chanArray[buttonid].play(self.soundAArray[buttonid], -1, 0, 100)
        #print "key entered long"

    def keyExitLong(self, buttonid):
        self.key[buttonid].show()
        self.chanArray[buttonid].stop() 
            
    def keyReleasedLong(self, buttonid):
        self.key[buttonid].show()
        self.chanArray[buttonid].fadeout(self.decay)

        
    @pyqtSignature("")
    def on_closeButton_pressed(self):
        #self.close()
        sys.exit()
        
    @pyqtSignature("int")
    def on_decaySlider_valueChanged(self, value):
        self.decay=value

    @pyqtSignature("int")
    def on_volSlider_valueChanged(self, value):
        if value>=1:self.vol=value/10.0
        self.chanArray[6].set_volume(self.vol)
        self.chanArray[6].play(self.soundAArray[6], 1)

    def disconnectShort(self):
        self.disconnect(self.grView, SIGNAL("stylo released"), self.keyReleasedShort)
        self.disconnect(self.grView, SIGNAL("stylo changed"),self.keyEnteredShort)
        self.disconnect(self.grView, SIGNAL("stylo exit"),self.keyExitShort)
        
    def disconnectLong(self):
        self.disconnect(self.grView, SIGNAL("stylo released"), self.keyReleasedLong)
        self.disconnect(self.grView, SIGNAL("stylo changed"),self.keyEnteredLong)
        self.disconnect(self.grView, SIGNAL("stylo exit"),self.keyExitLong)
        
    def connectShort(self):    
        self.connect(self.grView, SIGNAL("stylo released"),self.keyReleasedShort, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo changed"),self.keyEnteredShort, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo exit"),self.keyExitShort, self.buttonid)
        
    def connectLong(self):    
        self.connect(self.grView, SIGNAL("stylo released"),self.keyReleasedLong, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo changed"),self.keyEnteredLong, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo exit"),self.keyExitLong, self.buttonid)

            
    def voiceChanged(self, value):
        if value==1: 
            self.loadSamples()
            self.Display.setText("     Piano")
            self.disconnectLong()
            self.disconnectShort()
            self.connectShort()
        elif value==2:
            self.loadGSamples()
            self.Display.setText("     Guitar")
            self.disconnectLong()
            self.disconnectShort()
            self.connectShort()
        elif value==3:
            self.loadVSamples()
            self.Display.setText("     Violin")
            self.disconnectLong()
            self.disconnectShort()
            self.connectLong()
            
    @pyqtSignature("")
    def on_optionButton_clicked(self):
        self.configWin.show()
        
        
    @pyqtSignature("")
    def on_beatButton_pressed(self):
        self.beatWin.show()
        
    def config_window_closed(self, value):
     #handle config window closed custom  signals   
        print "Save Config Settings"

    def loadSamples(self):
        self.sampleDir="/home/opt/maesynth/piano_smpl/key"
        del self.soundAArray[:]
        for i in range(15):
            self.soundAArray.append(mixer.Sound(self.sampleDir+str(i)+".wav"))
        self.decay=500
        self.decaySlider.setMinimum(500)
        self.decaySlider.setMaximum(1500)
        self.decaySlider.setSliderPosition(500)  

    def loadBSamples(self):
        self.sampleDir="/home/opt/maesynth/beat_smpl/beat"
        self.soundBArray=[]
        for i in range(17):
            self.soundBArray.append(mixer.Sound(self.sampleDir+str(i)+".wav"))
                   
    def loadGSamples(self):
        self.sampleDir="/home/opt/maesynth/guitar_smpl/key"
        del self.soundAArray[:]
        for i in range(17):
            self.soundAArray.append(mixer.Sound(self.sampleDir+str(i)+".wav"))
        self.decay=500
        self.decaySlider.setMinimum(500)
        self.decaySlider.setMaximum(1500) 
        self.decaySlider.setSliderPosition(500)         
        
    def loadVSamples(self):
        self.sampleDir="/home/opt/maesynth/violin_smpl/key"
        del self.soundAArray[:]
        for i in range(17):
            self.soundAArray.append(mixer.Sound(self.sampleDir+str(i)+".wav"))
        self.decay=200
        self.decaySlider.setMinimum(200)
        self.decaySlider.setMaximum(1000)
        self.decaySlider.setSliderPosition(200)  

                   
    def initBeatChannels(self):
        """
        set up 1 channel instrument for bassbeat,starting from 30
        """
        for i in range(20):
            self.beatChan.append(mixer.Channel(i+30))
                   
    def initChannels(self):
        """
        set up 1 channel per key for polyphonic sound. Channel 0 is used for the base beat
        """
        for i in range(24):
            self.chanArray.append(mixer.Channel(i))
            
   
