# -*- coding: utf-8 -*-

"""
Module implementing beatWindow.
"""

from PyQt4.QtGui import QMainWindow, QLabel, QPushButton, QButtonGroup, QTableWidgetItem, QTableWidgetSelectionRange
from PyQt4.QtCore import pyqtSignature, QTimer, SIGNAL, QSize, QSettings, QBitArray, QVariant
from pygame import mixer
from Ui_beat import Ui_beatWindow


class beatWindow(QMainWindow, Ui_beatWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.beatArray=QBitArray(200)
        self.soundBArray=[]
        self.chanArray=[]
        self.beatChan=[]
        self.playing=0
        self.beatIndex=1
        self.beatCol=0
        self.tempo=20
        self.bpm=60
        self.decay=500
        self.sustain=0
        self.drum1Vol=0.5
        self.drum2Vol=0.5
        self.drum3Vol=0.5
        self.drum4Vol=0.5
        self.drum5Vol=0.5
        self.beatTimer = QTimer()
        self.initBeatChannels()
        self.loadBeatSounds()
        self.ledArray=[]
        self.bGroup=QButtonGroup()
        self.bGroup.setExclusive(0)
        self.id=1
        for r in range(5): 
            self.ledArray.append([])
            self.id=r+1
            for c in range(16):
                    self.ledArray[r].append(QPushButton(self))
                    self.ledArray[r][c].setCheckable(True) 
                    self.ledArray[r][c].setMinimumSize(QSize(60, 60))
                    self.table.setCellWidget(r,c,self.ledArray[r][c]); 
                    self.bGroup.addButton(self.ledArray[r][c], self.id)
                    self.id=self.id+5

        self.table.setProperty("FingerScrollable", 1)
        self.connect(self.bGroup, SIGNAL("buttonClicked(int)"),self.on_beat_Button_pressed)
        self.readConfig()
        self.showBeatArray()
        self.connect(self.beatTimer, SIGNAL("timeout()"), self.playBeat)

    
    
    
    def on_beat_Button_pressed(self, id):
        self.beatArray.toggleBit(id)

    @pyqtSignature("")
    def on_playpauseButton_clicked(self):
        if self.playing==0:
            self.playpauseButton.setText("Pause")
            self.beatTimer.start((1000/self.bpm)*64)
            self.playing=1
        else  :
            self.playpauseButton.setText("Start")
            self.beatTimer.stop()
            self.playing=0


    @pyqtSignature("")
    def on_stopButton_pressed(self):
        self.beatTimer.stop()
        self.table.setCurrentCell(0, 0)
        self.beatIndex=1
        self.beatCol=0
        self.playing=0
        self.playpauseButton.setChecked(0) 
        self.playpauseButton.setText("Start")

        
    @pyqtSignature("")
    def on_clearBeat_triggered(self):
        self.beatArray.fill(0)
        self.table.setCurrentCell(0, 0)
        self.showBeatArray()
        
    def showBeatArray(self):
        index=1
        for c in range(16): 
            for r in range(5):
                if self.beatArray.at(index)==0:self.ledArray[r][c].setChecked(0)
                else:  self.ledArray[r][c].setChecked(1)
                index=index+1           
                    
    @pyqtSignature("int")
    def on_tempoSlider_valueChanged(self, value):
        self.bpm=value
        self.lcd.setText(str(value))
        if self.playing==1:
            self.beatTimer.stop()
            self.beatTimer.start((1000/self.bpm)*64)
        

    def drum1VolChanged(self, value):
        if value>=1:self.drum1Vol=value/10.0
        #print "drum 1 vol", self.drum1Vol
        
    def drum2VolChanged(self, value):
        if value>=1:self.drum2Vol=value/10.0
        print "drum 2 vol", self.drum2Vol
        
    def drum3VolChanged(self, value):
        if value>=1:self.drum3Vol=value/10.0
        #print "drum 3 vol", self.drum3Vol
        
    def drum4VolChanged(self, value):
        if value>=1:self.drum4Vol=value/10.0
        #print "drum 4 vol", self.drum4Vol
        
    def drum5VolChanged(self, value):
        if value>=1:self.drum5Vol=value/10.0
        #print "drum 5 vol", self.drum5Vol
        
        
    def playBeat(self):
        """
        plays drum beat ,using channels
        """
        self.table.setCurrentCell(0, self.beatCol)
        if self.beatArray.at(self.beatIndex)==1:
            self.beatChan[1].set_volume(self.drum1Vol)
            self.beatChan[1].play(self.soundBArray[1])
        if self.beatArray.at(self.beatIndex+1)==1:
            self.beatChan[2].set_volume(self.drum2Vol)
            self.beatChan[2].play(self.soundBArray[2])
        if self.beatArray.at(self.beatIndex+2)==1:
            self.beatChan[3].set_volume(self.drum3Vol)
            self.beatChan[3].play(self.soundBArray[3])
        if self.beatArray.at(self.beatIndex+3)==1:
            self.beatChan[4].set_volume(self.drum4Vol)
            self.beatChan[4].play(self.soundBArray[4])
        if self.beatArray.at(self.beatIndex+4)==1:
            self.beatChan[5].set_volume(self.drum5Vol)
            self.beatChan[5].play(self.soundBArray[5])
    
        self.beatIndex=self.beatIndex+5
        self.beatCol=self.beatCol+1
        if self.beatIndex>80:self.beatIndex=1
        if self.beatCol==16:self.beatCol=0
        
    def initBeatChannels(self):
        """
        set up 1 channel per instrument for bassbeat,starting from 30
        """
        for i in range(6):
            self.beatChan.append(mixer.Channel(i+30))
            #self.beatChan.append(mixer.Channel(i))
            
    def loadBeatSounds(self):
        self.sampleDir="/home/opt/maesynth/drum_smpl/"
        self.soundBArray=[]
        self.soundBArray.append(mixer.Sound(self.sampleDir+"hihat-closed1.wav"))
        self.soundBArray.append(mixer.Sound(self.sampleDir+"hihat-closed1.wav"))
        self.soundBArray.append(mixer.Sound(self.sampleDir+"snare.wav"))
        self.soundBArray.append(mixer.Sound(self.sampleDir+"tom3.wav"))
        self.soundBArray.append(mixer.Sound(self.sampleDir+"bass.wav"))
        self.soundBArray.append(mixer.Sound(self.sampleDir+"cymbol2.wav"))
        
    def closeEvent(self, event):
        #emit custom signal when window is closed
        self.writeConfig()
        #self.emit(SIGNAL("window closed"), self.config)
        event.accept()

    def readConfig(self):
    #read the config file  from QSettings 
        self.settings=QSettings("AcaciaClose", "maesynth")
        if self.settings.contains("beatArray")==1:
            self.beatArray=self.settings.value("beatArray").toBitArray()
            #print "read", self.beatArray.at(0),  self.beatArray.at(1),  self.beatArray.at(2),  self.beatArray.at(3),  self.beatArray.at(4),  self.beatArray.at(5)

            
    def writeConfig(self):
        #save the beat settings
        self.settings=QSettings("AcaciaClose", "maesynth")
        self.settings.setValue("beatArray", QVariant(self.beatArray))



        
