# -*- coding: utf-8 -*-
from PyQt4.QtGui import QMainWindow, QGraphicsView
from PyQt4.QtCore import pyqtSignature, Qt, SIGNAL, QPoint




class styloKeys(QGraphicsView):
    """
    Class documentation goes here.
    """
    
    def __init__(self, parent):
        QGraphicsView.__init__(self, parent)
        # some custom properties and functions will follow
        self.keyid=[1, 1, 9, 9, 9, 2, 2,10, 10,10, 3, 3, 4, 4, 11, 11, 11, 5, 5, 12, 12, 12, 6, 6, 13, 13, 7, 7, 8, 8, 14, 14]
        self.lastbutton=13
        self.keyrelease=1
        self.keyevent=0
        self.keySet=set()
        self.keypressed=''
        
    def mousePressEvent(self, event):
        self.getButtonid(event)
        self.emit(SIGNAL("stylo changed"),self.buttonid)        
        self.keyrelease=0
        #print "keypressed", self.buttonid, self.x, self.y
        self.lastbutton=self.buttonid
        event.accept()
        
    def mouseDoubleClickEvent(self, event):    
        self.getButtonid(event)
        self.emit(SIGNAL("stylo changed"),self.buttonid)   
        self.emit(SIGNAL("stylo changed"),self.buttonid)            
        self.keyrelease=0
        #print "keypressed", self.buttonid, self.x, self.y
        self.lastbutton=self.buttonid
        event.accept()
        
    def mouseReleaseEvent(self, event):
        self.emit(SIGNAL("stylo released"), self.buttonid)
        self.getButtonid(event)
        self.keyrelease=1
        event.accept()
    
    def mouseMoveEvent(self, event):
        if self.keyrelease==1:return
        self.getButtonid(event)
        if self.buttonid!=self.lastbutton:
            self.emit(SIGNAL("stylo changed"), self.buttonid)
            self.emit(SIGNAL("stylo exit"), self.lastbutton)
            #print self.buttonid
        #print "mouse moved", self.buttonid, self.x, self.y, self.buttonid
        self.lastbutton=self.buttonid
        event.accept()
    """
    def keyPressEvent(self, event):
        if event.isAutoRepeat()==1:
            event.ignore()
            return
        if event.key() in self.keySet :event.ignore()
        else:
            self.keySet.add(event.key())
            event.accept()

    def keyReleaseEvent(self, event):
        if event.isAutoRepeat()==1:
            event.ignore()
            return
        if event.key() in self.keySet :
            self.keySet.remove(event.key())
            event.accept()
        else:event.ignore() 
    """
    def getButtonid(self, event):
        self.mousePressPos = QPoint(event.pos())
        self.x = self.mousePressPos.x()
        self.y = self.mousePressPos.y()
        #check to see if we aare inside the qgraphicsview,then see if we are in bottom or top half of keyboard
        if self.x<=800 and self.x>=0:
            if self.y>=224:self.buttonid=int(self.x/100)+1
            #otherwise need to find small button. upper keyboard divided into 24 keys
            else:
                tempbuttonid=int(self.x/25)
                self.buttonid=self.keyid[tempbuttonid]
             #has a key been pressed  
    
    
