# -*- coding: utf-8 -*-
"""
Module implementing MainWindow.
"""
from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect, Qt, QBasicTimer
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView, QPixmap, QImage, QGraphicsPixmapItem
from pygame import mixer, init as pginit
#import time
#This is the Pygame version for Audio
from Ui_sound import Ui_MainWindow
import sys
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        FREQ = 22050   # play with this for best sound
        BITSIZE = -16  # here unsigned 16 bit
        CHANNELS = 2   # 1 is mono, 2 is stereo
        BUFFER = 32 # audio buffer size, number of samples
        
        #myRecorder=audioRecorder(self)



        mixer.pre_init(FREQ, BITSIZE, CHANNELS, BUFFER)
        pginit()
        self.soundArray=[]
        self.soundBArray=[]
        self.bpm=0
        self.decay=10
        self.vol=0.5
        self.vibra=0
        self.organ=0
        self.loadSamples()
        self.key=[]
        for c in range(20):
            self.key.append(QGraphicsPixmapItem())
    
        #Build the Keyboard using QGraphicsView
        self.buttonid=0
        self.scene = QGraphicsScene()
        self.sceneWidth=800
        self.sceneHeight=400
        self.centerx=0
        self.centery=0
        self.svgRect=QRect()
        
        pixmap1 = QPixmap(100, 400)
        pixmap1.load("images/key1.png")
        pixmap2 = QPixmap(100, 400)
        pixmap2.load("images/key2.png")
        pixmap3 = QPixmap(100, 400)
        pixmap3.load("images/key3.png")
        pixmap4 = QPixmap(100, 400)
        pixmap4.load("images/key4.png")
        pixmap5 = QPixmap(100, 400)
        pixmap5.load("images/key5.png")
        
        pixmap6 = QPixmap(56, 223)
        pixmap6.load("images/bkey1.png")
        
        pixmap7 = QPixmap(56, 223)
        pixmap7.load("images/bkey2.png")
        
        pixmap8 = QPixmap(56, 223)
        pixmap8.load("images/bkey3.png")
        
        pixmap9 = QPixmap(56, 223)
        pixmap9.load("images/bkey4.png")
        
        pixmap10 = QPixmap(56, 223)
        pixmap10.load("images/bkey5.png")
        
        pixmap11 = QPixmap(56, 223)
        pixmap11.load("images/bkey6.png")
        
        
        
      
        self.key[1].setPixmap(pixmap1)
        self.key[1].setPos(0, 0)
        self.scene.addItem(self.key[1])
        
        self.key[2].setPixmap(pixmap2)
        self.key[2].setPos(100, 0)
        self.scene.addItem(self.key[2])
        
        self.key[3].setPixmap(pixmap3)
        self.key[3].setPos(200, 0)
        self.scene.addItem(self.key[3])
        
        self.key[4].setPixmap(pixmap1)
        self.key[4].setPos(300, 0)
        self.scene.addItem(self.key[4])
        
        self.key[5].setPixmap(pixmap4)
        self.key[5].setPos(400, 0)
        self.scene.addItem(self.key[5])
        
        self.key[6].setPixmap(pixmap5)
        self.key[6].setPos(500, 0)
        self.scene.addItem(self.key[6])
        
        self.key[7].setPixmap(pixmap3)
        self.key[7].setPos(600, 0)
        self.scene.addItem(self.key[7])
        
        
        self.key[8].setPixmap(pixmap1)
        self.key[8].setPos(700, 0)
        self.scene.addItem(self.key[8])
        
        self.key[9].setPixmap(pixmap6)
        self.key[9].setPos(58, 0)
        self.scene.addItem(self.key[9])
        
        self.key[10].setPixmap(pixmap7)
        self.key[10].setPos(183, 0)
        self.scene.addItem(self.key[10])
        
        self.key[11].setPixmap(pixmap8)
        self.key[11].setPos(359, 0)
        self.scene.addItem(self.key[11])
        
        self.key[12].setPixmap(pixmap9)
        self.key[12].setPos(473, 0)
        self.scene.addItem(self.key[12])
        
        self.key[13].setPixmap(pixmap10)
        self.key[13].setPos(584, 0)
        self.scene.addItem(self.key[13])
        
        self.key[14].setPixmap(pixmap11)
        self.key[14].setPos(760, 0)
        self.scene.addItem(self.key[14])
        


        #self.image=QPixmap.load ("keyup.png", 0)
        
       #self.centerx=self.sceneWidth/2
        #self.centery=self.sceneHeight/2
        #self.grView.centerOn(self.centerx, self.centery)
        #self.grView.scale(1, 1)
     
        self.grView.setScene(self.scene)
        
        self.connect(self.grView, SIGNAL("stylo released"),self.pushButtonReleased, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo changed"),self.pushButtonEntered, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo exit"),self.pushButtonExit, self.buttonid)
        
        self.aChannel=mixer.Channel(1)
        self.bChannel=mixer.Channel(2)
        mixer.stop()
        
        self.beatTimer = QBasicTimer()
        #self.beatTimer.start(1000, self)
        self.beatIndex=1
        self.loadBSamples()
        
    def timerEvent(self, event):
        """
        plays drum beat 
        """
        self.bChannel.set_volume(self.vol)
        self.bChannel.play(self.soundBArray[self.beatIndex])
        self.beatIndex=self.beatIndex+1
        if self.beatIndex==17:self.beatIndex=1
            
    def pushButtonPressed(self, buttonid):
        #play a 5 second burst (-1,5000) minus specifies play contiunous
        self.playSound(buttonid)
        
   
    def pushButtonReleased(self, buttonid):
        #self.aChannel.stop()
        self.aChannel.fadeout(self.decay)
        self.key[buttonid].show()
        
    @pyqtSignature("")
    def on_closeButton_pressed(self):
        #self.close()
        sys.exit()
        
    @pyqtSignature("int")
    def on_decaySlider_valueChanged(self, value):
        self.decay=value

    @pyqtSignature("int")
    def on_volSlider_valueChanged(self, value):
        if value>=1:self.vol=value/10.0
        self.aChannel.set_volume(self.vol)
        self.bChannel.set_volume(self.vol)
        self.aChannel.play(self.soundArray[6], 1)
        
    @pyqtSignature("int")
    def on_vibraSlider_valueChanged(self, value):
        if value==1:
            self.loadSamples()
            self.vibra=1
        else: 
            self.organSlider.setSliderPosition(1)
            self.loadVSamples()
            self.vibra=0
        
    @pyqtSignature("int")
    def on_bpmSlider_sliderMoved(self, value):
      
        if value==20: self.beatTimer.stop()
        else:
            self.bpm=30000/value
            self.beatTimer.start(self.bpm, self)


        
    @pyqtSignature("int")
    def on_drumSlider_valueChanged(self, value):
        self.bChannel.set_volume(self.vol)
        if value==1:
            self.soundArray[0]=(mixer.Sound("/home/opt/maesynth/stylo_smpl/drum1.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==2: 
            self.soundArray[0]=(mixer.Sound("/home/opt/maesynth/stylo_smpl/drum2.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==3: 
            self.soundArray[0]=(mixer.Sound("/home/opt/maesynth/stylo_smpl/drum3.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==0:  self.bChannel.fadeout(self.decay)
   
    def pushButtonEntered(self, buttonid):
        #mixer.fadeout(self.decay)
        self.aChannel.fadeout(self.decay)
        self.playSound(buttonid)
        self.key[buttonid].hide()
        
    def pushButtonExit(self, buttonid):
        #mixer.fadeout(self.decay)
        self.key[buttonid].show()

    def playSound(self, buttonid):
        self.aChannel.set_volume(self.vol)
        self.aChannel.play(self.soundArray[buttonid])
     
    def loadSamples(self):
        #mixer.init(FREQ, BITSIZE, CHANNELS, BUFFER)
        self.soundArray= []
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/drum_beat.wav")) #e
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano1.wav"))      #1 a
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano2.wav") )     #2 b
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano3.wav")  )    #3 c
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano4.wav") )     # 4 d
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano5.wav") )      # 5e
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano6.wav") )      # 6f
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano7.wav") )      #7 g
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano8.wav"))      #8 a
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano9.wav") )     #9b
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano10.wav") )      #10 c
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano11.wav") )       #11d
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano12.wav"))         # 12 e
        
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano13.wav")) #13 a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/piano14.wav") ) # 14 c sharp
        
    def loadVSamples(self):
        self.soundArray= []
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/drum_beat.wav")) #e
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/a2v.wav"))      #1 a
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/b2v.wav") )     #2 b
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/c3v.wav")  )    #3 c
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/d3v.wav") )     # 4 d
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/e3v.wav") )      # 5e
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/f3v.wav") )      # 6f
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/g3v.wav") )      #7 g
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/a3v.wav"))      #8 a
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/b3v.wav") )     #9b
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/c4v.wav") )      #10 c
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/d4v.wav") )       #11d
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/e4v.wav"))         # 12 e
        
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/a#2v.wav")) #13 a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/c#3v.wav") ) # 14 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/d#3v.wav"))  #15 d sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/f#3v.wav"))  #16 f sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/g#3v.wav"))  #17 g sharp  
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/a#3v.wav"))  #18a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/c#4v.wav")) # 19 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maesynth/stylo_smpl/d#4v.wav"))  #20 d sharp

    def loadBSamples(self):
        self.soundBArray= []
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/drum_beat.wav")) #e
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat1.wav"))      #1 a
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat2.wav") )     #2 b
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat3.wav")  )    #3 c
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat4.wav") )     # 4 d
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat5.wav") )      # 5e
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat6.wav") )      # 6f
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat7.wav") )      #7 g
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat8.wav"))      #8 a
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat9.wav") )     #9b
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat10.wav") )      #10 c
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat11.wav") )       #11d
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat12.wav"))         # 12 e
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat13.wav") )      # 6f
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat14.wav") )      #7 g
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat15.wav"))      #8 a
        self.soundBArray.append(mixer.Sound("/home/opt/maesynth/beat_smpl/beat16.wav") )     #9b
    
        
        
