# define DEFAULT_AUDIOSRC "pulsesrc"
# define DEFAULT_AUDIOSINK "pulsesink"

#include <string.h>
#include <math.h>
#include <gst/gst.h>
#include <gconf/gconf-client.h>
#include <stdio.h>
#include <glib-object.h>

#include "gstpitch.h"
#include <dbus/dbus.h>

#include <glib.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>

extern gboolean plugin_pitch_init (GstPlugin * plugin);
extern gboolean plugin_tonesrc_init (GstPlugin * plugin);


int sheepPid=0;
gfloat frequency=0;
int checkCounter=0;

struct app_data
{

  GstElement *bin1;
  GstElement *tonesrc;
  GstElement *pitch;
};

typedef struct app_data AppData;


/* update frequency info */
static void
update_frequency ()
{
  emitState();
}

/* receive spectral data from element message */
gboolean message_handler (GstBus * bus, GstMessage * message, gpointer data)
{

//	g_print("here gst \n");
  if (message->type == GST_MESSAGE_ELEMENT) 
  {
    const GstStructure *s = gst_message_get_structure (message);
    const gchar *name = gst_structure_get_name (s);

    if (strcmp (name, "pitch") == 0) 
    {
   //   gfloat frequency=0;
	

      frequency = g_value_get_float (gst_structure_get_value (s, "frequency"));
  
    
    if (frequency != 0)
      update_frequency ();
    }
  }
  return TRUE;
}




static void
set_pipeline_states (AppData * appdata, GstState state)
{
    if (appdata->bin1)
      gst_element_set_state (appdata->bin1, state);

}

int checkProcess()     //checking active processes
{

        DIR *dir_p;
        struct dirent *dir_entry_p;
        dir_p = opendir("/proc/");
		
        while(NULL != (dir_entry_p = readdir(dir_p)))
        {                      
                if (strspn(dir_entry_p->d_name, "0123456789") == strlen(dir_entry_p->d_name))
                {
                        int ppid = atoi(dir_entry_p->d_name);
			
		    	if (ppid==sheepPid)
	    		{
     				return;
			}
                }
        }

	exit(0);
	return;
}




              
DBusMessage* msgSig;
DBusMessageIter argsSig;
DBusConnection* connSig;
DBusError errSig;
int retSig;
dbus_uint32_t serialSig;
												


void connectToDbusSignal() 
{

	dbus_error_init(&errSig);
	connSig = dbus_bus_get_private(DBUS_BUS_SESSION, &errSig);
	
	if (dbus_error_is_set(&errSig))
	{
		dbus_error_free(&errSig);
	}

	
	if (NULL == connSig)
	{
		exit(1);
	}

	retSig = dbus_bus_request_name(connSig, "tune.signal.source", DBUS_NAME_FLAG_REPLACE_EXISTING , &errSig);
	
	if (dbus_error_is_set(&errSig))
	{
		dbus_error_free(&errSig);
	}
	
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retSig)
	{
		exit(1);
	}

}



void emitState() //emitting change signals
{

	if (checkCounter>20)
	{
		checkProcess();
	}
	else
		++checkCounter
	
	double freq = (double)frequency;
	
	
	
	msgSig = dbus_message_new_signal("/tune/signal/state", // object name of the signal
			"tune.signal.state", // interface name of the signal
			"changed"); // name of the signal
	
	if (NULL == msgSig)
	{
		return;
	}

	dbus_message_iter_init_append(msgSig, &argsSig);
	
	if (!dbus_message_iter_append_basic(&argsSig, DBUS_TYPE_DOUBLE, &freq))
	{
		return;
	}
	
	if (!dbus_connection_send(connSig, msgSig, &serialSig))
	{
		return;
	}

}






 int connectedMute;
 DBusMessage* msgMute;
 DBusMessageIter argsMute;
 DBusConnection* connMute;
 DBusError errMute;
 int retMute;
 double sigvalueMute;
						       


void connectToDbusMute()
{

        dbus_error_init(&errMute);
        connMute = dbus_bus_get_private(DBUS_BUS_SESSION, &errMute);

        if (dbus_error_is_set(&errMute))
        {
                dbus_error_free(&errMute);
        }

        if (NULL == connMute)
        {
                return;
        }

        retMute = dbus_bus_request_name(connMute, "tune.mute", DBUS_NAME_FLAG_REPLACE_EXISTING , &errMute);

        if (dbus_error_is_set(&errMute))
        {
                dbus_error_free(&errMute);
        }

        if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retMute)
        {
                return;
        }

        dbus_bus_add_match(connMute, "type='signal',interface='maesheep.signal.state'", &errMute);
        dbus_connection_flush(connMute);

        if (dbus_error_is_set(&errMute))
        {
                return;
        }
        connectedMute=1;
}

DBusHandlerResult DBusCallback( DBusConnection* connection, DBusMessage* message, void* user_data)
{

	g_print("here loop \n");

	double state=0;
        DBusError errMute_;


        dbus_error_init (&errMute_);

        if (dbus_message_is_signal (message, "maesheep.signal.state", "changed"))
        {
                if (dbus_message_get_args(message, &errMute_, DBUS_TYPE_DOUBLE, &state, DBUS_TYPE_INVALID))
                {
			g_print("//// %d",state);
                }

                return DBUS_HANDLER_RESULT_HANDLED;
        }

        return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}



  





int main (int argc, char *argv[])
{


	

	if (argc>1)
	{
		sheepPid=atoi(argv[1]);
		g_print("%d",sheepPid);

		
	}
	else return 1;
	
	connectToDbusSignal();
      
	AppData * appdata = NULL;

  GstElement *src1, *sink1;
  GstBus *bus;

  appdata = g_new0(AppData, 1);

  /* Init GStreamer */
  gst_init (&argc, &argv);
  /* Register the GStreamer plugins */
  plugin_pitch_init (NULL);
  plugin_tonesrc_init (NULL);


  /* Bin for tuner functionality */
  appdata->bin1 = gst_pipeline_new ("bin1");

  src1 = gst_element_factory_make (DEFAULT_AUDIOSRC, "src1");
  g_object_set (G_OBJECT (src1), "device", "source.voice.raw", NULL);

  appdata->pitch = gst_element_factory_make ("pitch", "pitch");

  g_object_set (G_OBJECT (appdata->pitch), "message", TRUE, "minfreq", 10,
      "maxfreq", 4000, 
      "algorithm", 
      0,
      NULL);

  sink1 = gst_element_factory_make ("fakesink", "sink1");
  g_object_set (G_OBJECT (sink1), "silent", 1, NULL);

  gst_bin_add_many (GST_BIN (appdata->bin1), src1, appdata->pitch, sink1, NULL);
  if (!gst_element_link_many (src1, appdata->pitch, sink1, NULL)) {
    fprintf (stderr, "cant link elements\n");
    exit (1);
  }
	
 GMainLoop* g_loop = NULL;
 g_loop = g_main_loop_new(NULL,FALSE);

// connectToDbusMute();

	

//dbus_connection_setup_with_g_main(connMute, NULL);
//dbus_bus_add_match(connMute, "maesheep.signal.state", &errMute );
//dbus_connection_add_filter(connMute, DBusCallback, g_loop, NULL);

  
  bus = gst_element_get_bus (appdata->bin1);
  gst_bus_add_watch (bus, message_handler, appdata);
  gst_object_unref (bus);
  set_pipeline_states (appdata, GST_STATE_PLAYING);

  
		


	

	
//      	gtk_main ();

  
	 g_main_loop_run(g_loop);

  
  set_pipeline_states (appdata, GST_STATE_NULL);

  gst_object_unref (appdata->bin1);
  return 0;
}
