#include <platform.h>

Game* Platform::game=NULL;

Platform::Platform(qreal x_, qreal y_, qreal sizeX_, qreal sizeY_, int type_, int sheepTh_):x(x_),y(y_),sizeX(sizeX_),sizeY(sizeY_),type(type_),sheepTh(sheepTh_),sheepCounter(0)
{
	objType=4;
	setZValue(platformDepth);
	activated=0;
	counter=0;
}

QRectF Platform::boundingRect() const
{
	        return QRectF(0,0,sizeX,sizeY);
}

void Platform::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{

	for (int i=0;i<connectedFences.size();++i)
	{

 
		QPen pen(activated? Qt::green : Qt::red, 3, Qt::DotLine, Qt::RoundCap, Qt::RoundJoin);
		painter->setPen(pen);
		painter->drawLine(sizeX/2,sizeY/2,connectedFences[i]->x-x+40,connectedFences[i]->y-y+40);
	}

	painter->setOpacity(0.1+(std::min((double)sheepCounter/(double)sheepTh,1.0))/2.0);
	painter->setPen(Qt::blue);
	painter->setBrush(Qt::blue);
	painter->drawRect(boundingRect());

}



void Platform::advance(int step)
{
	if (!step || game->pauseOn)
		return;

	//if (activated)
	{
		counter=(counter+1)%3;
		if (counter==0) 
		{
			sheepCounter=0;
			sheeps.clear();
		}

	}
	
	if (sheepCounter>=sheepTh && !activated)
	{
		activate();
	}
	
	else if (sheepCounter<sheepTh && activated && counter==2)
	{
		deactivate();
		sheepCounter=0;
		sheeps.clear();
	}
	setPos(x,y);

}


void Platform::addFence(Fence* fence_)
{
	for (int i=0;i<connectedFences.size();++i)
	{
		if (connectedFences[i]==fence_)
			return;
	}

	connectedFences.push_back(fence_);
}

void Platform::deleteFence(Fence* fence_)
{

	for (int i=0;i<connectedFences.size();++i)
	{
		if (connectedFences[i]==fence_)
			connectedFences.erase(connectedFences.begin()+i);
	}

}

void Platform::activate()
{
	std::cout<<"activate"<<std::endl;
	activated=1;
	
	for (int i=0;i<connectedFences.size();++i)
	{
		connectedFences[i]->platformActivate();
	}
	

}


void Platform::deactivate()
{
	activated=0;
	std::cout<<"deactivate"<<std::endl;

	for (int i=0;i<connectedFences.size();++i)
	{
		connectedFences[i]->platformDeactivate();
	}
	

}


void Platform::addSheep(Sheep* sheep_)
{

	for (int i=0;i<sheeps.size();++i)
	{
		if (sheeps[i]==sheep_)
			return;	
	}

	sheeps.push_back(sheep_);
	sheepCounter=sheeps.size();
}
	
