#ifndef POI_H
#define POI_H

#include <QGraphicsItem>
#include <game.h>
#include <baseobj.h>
#include <vec.h>
#include <sheep.h>


class Vec;
class Sheep;

class Poi:public QWidget, public QGraphicsItem, public BaseObj
{
	Q_OBJECT
public:
		Poi(qreal x_, qreal y_, qreal value_, qreal attraction_, int type_);
		void paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget);
		QRectF boundingRect() const;
		static Game* game;
		qreal x;
		qreal y;
		qreal value;
		qreal attraction;
		int type;
		Vec* colVec;
private:
		void advance(int step);
		
signals:
		void deleteMe(Poi*);
};
#endif
