#include <fence.h>

Game* Fence::game=NULL;
View* Fence::view=NULL;


Fence::Fence() 
{
	setZValue(fenceDepth);
	objType=2;
	cRotation=0;
	active=1;
	dRotation=0;
	closeCounter=0;
	dogIn=0;

}

void Fence::addSheep(Sheep* sheep_)
{
	for (int i=0;i<sheepIn.size();++i)
	{
		if (sheepIn[i]==sheep_)
			return;

	}

	sheepIn.push_back(sheep_);
}


QRectF Fence::boundingRect() const
{
	return QRectF(0,0,80,74);
}

QPainterPath Fence::shape() const
{
	QPainterPath path;
	//path.addRect(boundingRect());
	path.addRect(QRectF(2,0,15,95));
	path.addRect(QRectF(85,0,15,95));
	path.addRect(QRectF(17,0,68,15));
	if (!active)
		path.addRect(QRectF(17,80,68,15));
		
	return path;
}

void Fence::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{	
	if (active)
		painter->drawPixmap(0,0,game->fencePix);
	else
		painter->drawPixmap(0,0,game->fenceClosedPix);
		
//	painter->setPen(Qt::white);
//	painter->drawPath(shape());

}


void Fence::advance(int step)
{

	if (!step || game->pauseOn)
		return;

	if (sheepIn.size()==0 || sheepIn.size()>1 || dogIn==1) //don't close if there is no sheep or many sheep
	{
		closeCounter=0;
		sheepIn.clear();
		dogIn=0;
	}
	else
	{
		++closeCounter;
		if (closeCounter==2 && active==1)
		{
			active=0;
			closeCounter=0;
			sheepIn[0]->active=0;
			std::cout<<"caught"<<std::endl;
			game->vibrate(2);
			game->caught();
			for (int i=0;i<view->platforms.size();++i)
			{
				view->platforms[i]->deleteFence(this);

			}

			if (game->sound)
			{
				pthread_t bahSoundThread;
				pthread_create(&bahSoundThread,NULL,&SoundEngine::playSingleBah,NULL);
			}
	
		}
	}
	
	
	cRotation=(cRotation+dRotation);
	setTransformOriginPoint(game->fencePix.width()/2,game->fencePix.height()/2);
	setPos(x,y);
	setRotation(cRotation);

}


void Fence::platformActivate()
{
	active=1;
}


void Fence::platformDeactivate()
{
	active=0;
}
