/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  checkbutton_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT)
{
  set_title("Hildon::CheckButton example");

  checkbutton_.set_label("Check me!");
  
  box_.add(checkbutton_);
  add(box_);

  checkbutton_.signal_toggled().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_toggled));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_toggled()
{
  std::cout << "Button toggled: current state=" << checkbutton_.get_active() << std::endl;
}

