/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/
//for minite timer
/*************************************************************************************************
**
** file:    betweentime.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef BETWEENTIME_H
#define BETWEENTIME_H

#include <QObject>
#include <qdatetime.h>
#include <qdebug.h>
#include <qbasictimer.h>
#include <qapplication.h>
#include "conditioninterface.h"
//====================================================
/*
  Jako hodiny ale budou jen jedny
*/
class MinuteTimer : public QObject
{
	Q_OBJECT
public:
	MinuteTimer(QObject *parent) : QObject(parent)
	{
	}
	void start()//start casu
	{
		if (!timer.isActive()) {
			time = QTime::currentTime();
			timer.start(60000-time.second()*1000, this);
		}//event dostane tento objekt
	}
	void stop()//zastaveni kdyz se nepouziva
	{
		timer.stop();
	}

	int hour() const { return time.hour(); }
	int minute() const { return time.minute(); }

signals:
	void timeChanged();

protected:
	void timerEvent(QTimerEvent *)//kdyz je minuta pryc
	{
		QTime now = QTime::currentTime();//from some example
		if (now.second() == 59 && now.minute() == time.minute() && now.hour() == time.hour()) {
			// just missed time tick over, force it, wait extra 0.5 seconds
			time.addSecs(60);
			timer.start(60500, this);
		} else {
			time = now;
			timer.start(60000-time.second()*1000, this);
		}
		emit timeChanged();//zmena
	}

private:
	QTime time;
	QBasicTimer timer;
};
//====================================================
//urci zda je cas mezi nastavenymi casy
class BetweenTime : public Condition
{
	Q_OBJECT

	Q_PROPERTY(QTime startTime READ startTime WRITE setStartTime NOTIFY notifyTimeChangedStart)
	Q_PROPERTY(QTime endTime READ endTime WRITE setEndTime NOTIFY notifyTimeChangedEnd)


	Q_PROPERTY(int startTimeHour READ getStartTimeHour WRITE setStartTimeHour NOTIFY notifyTimeChangedStart)
	Q_PROPERTY(int startTimeMinute READ getStartTimeMinute WRITE setStartTimeMinute NOTIFY notifyTimeChangedStart)
	Q_PROPERTY(int endTimeHour READ getEndTimeHour WRITE setEndTimeHour NOTIFY notifyTimeChangedEnd)
	Q_PROPERTY(int endTimeMinute READ getEndTimeMinute WRITE setEndTimeMinute NOTIFY notifyTimeChangedEnd)

	Q_PROPERTY(bool isSetStart READ getIsSetmin NOTIFY notifyTimeChangedStart)
	Q_PROPERTY(bool isSetEnd READ getIsSetmax NOTIFY notifyTimeChangedEnd)
public:
	explicit BetweenTime(ConditionInterface *interface);


	int getStartTimeHour() const { return starttime.hour();}
	int getStartTimeMinute() const { return starttime.minute();}
	int getEndTimeHour() const { return endtime.hour();}
	int getEndTimeMinute() const { return endtime.minute();}

	void setStartTimeHour(int h) {starttime = QTime(h,starttime.minute());}
	void setStartTimeMinute(int m) {starttime = QTime(starttime.hour(),m);}
	void setEndTimeHour(int h) {endtime = QTime(h,endtime.minute());}
	void setEndTimeMinute(int m) {endtime = QTime(endtime.hour(),m);}

	Q_INVOKABLE void setStartTime(int hour, int min) { starttime = QTime(hour,min); isSetStart = true; emit notifyTimeChangedStart();}
	Q_INVOKABLE void setEndTime(int hour, int min) { endtime = QTime(hour,min); isSetEnd = true; emit notifyTimeChangedEnd();}

	Q_INVOKABLE QString getStartTostring() { return starttime.toString("hh:mm:ss");}
	Q_INVOKABLE QString getEndTostring() {  return endtime.toString("hh:mm:ss");}

	virtual void load(const QByteArray &data);
	virtual QByteArray save() const;

	//vraceni casu min a max

	//jeslti je aktualni cas mezi min a max

	QTime startTime() const { return starttime; }
	QTime endTime() const { return endtime; }



	~BetweenTime();

	bool getIsSetmin() const {return isSetStart;}
	bool getIsSetmax() const {return isSetEnd;}
signals:
	void notifyTimeChangedStart();//kdys se nastavi jiny cas
	void notifyTimeChangedEnd();//kdys se nastavi jiny cas
	void notifyBoolValueChange();//kdyz se zmeni hodnota teto podminky

public slots:
	void detectBetween();//funkce detekuje jeslti je to mezi

	//    void setStartTime(int hour, int min) { starttime = QTime(hour,min); isSetStart = true; emit notifyTimeChangedStart();}
	//    void setEndTime(int hour, int min) { endtime = QTime(hour,min); isSetEnd = true; emit notifyTimeChangedEnd();}

	void setStartTime(QTime time) { starttime = time; isSetStart = true; emit notifyTimeChangedStart();}
	void setEndTime(QTime time) { endtime = time; isSetEnd = true; emit notifyTimeChangedEnd();}

private:


private:
	QTime starttime;
	QTime endtime;

	static MinuteTimer *timer;
	static int instances;

	bool isSetStart;
	bool isSetEnd;


	int startTimeHour;
	int startTimeMinute;
	int endTimeHour;
	int endTimeMinute;
};
//====================================================
class BetweenTimeInterface : public ConditionInterface
{
	Q_OBJECT
	Q_INTERFACES(ConditionInterface)

public:
	virtual QString name() const { return tr("Time"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual BetweenTime *createCondition() { return new BetweenTime(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:BetweenTime.qml"); }
	virtual QUrl icon() const { return QUrl("qrc:time.png"); }
};
//====================================================

#endif // BETWEENTIME_H
