/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    lightsensors.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "lightsensor.h"
#include <QDebug>
LightSensor::LightSensor(ConditionInterface *interface) :
	Condition(interface),lightLevel(1)
{
	connect(&sensor, SIGNAL(readingChanged()), this, SLOT(update()));
	connect(&sensor, SIGNAL(readingChanged()), this, SIGNAL(notifyLightLevelMobileValueChange()));
	sensor.start();
	update();
}

void LightSensor::update()
{
	detectChange((sensor.reading()));
}

int  LightSensor::getLightMobileLevel()
{
	QAmbientLightReading * val = sensor.reading();
	if(val != NULL)
	{
		return val->lightLevel();
	}
	else
	{
		return -1;
	}
}

void LightSensor::detectChange(QAmbientLightReading * reading)
{
	if(reading != NULL)
	{
		//        if(reading->lightLevel() == QAmbientLightReading::Dark)
		qDebug() << "level co jsem nastavil " << lightLevel << " co ctu " << reading->lightLevel();
		if((lightLevel <= reading->lightLevel()) && (reading->lightLevel() != 0  ))
		{
			setState(true);
			qDebug() << "status je " << true ;
		}
		else
		{
			setState(false);
			qDebug() << "status je " <<  false;
		}
	}
}

LightSensor::~LightSensor()//kdyz se smaze
{
	sensor.stop();
}

void LightSensor::load(const QByteArray &data)
{
	QDataStream stream(data);
	stream >> lightLevel;
}

QByteArray LightSensor::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);
	stream << lightLevel;
	return data;
}

Q_EXPORT_PLUGIN2(lightsensor, LightSensorInterface)
