/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    main.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

//import QtQuick 1.0
//import Qt.labs.components.native 1.0
//import com.nokia.extras 1.0
import QtQuick 1.0
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0

Rectangle {
    id: rectangle1
    width: 800
    height: 480
    color: "#000000"
    Text {
        x: 368
        y: 81
        color: "#ffffff"
        text: "Set radious from current location"
        font.pointSize: 21
        anchors.verticalCenterOffset: -151
        anchors.horizontalCenterOffset: 0
        anchors.centerIn: parent
    }
    Slider {
        id: sliderrGPS
        x: 68
        y: 127
        width: 674
        height: 100
        maximumValue: 1000
        minimumValue: 10
        value: Instance.radious
        stepSize: 1
        valueIndicatorVisible: true
        //valueIndicatorText: "Repeat"
    }

    Button {
        id: buttonGPS
        x: 320
        y: 231
        text: "Save"
        width: parent.width /5
        height: parent.height / 5
        onClicked: {
            setMess()
        }

    }

    function setMess()
    {
        Instance.radious =  sliderrGPS.value;
    }
}
