/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    gpslocation.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef GPSLOCATION_H
#define GPSLOCATION_H


#include <QObject>
#include "conditioninterface.h"
#include <qgeoareamonitor.h>
#include <qgeopositioninfo.h>
#include <QGeoPositionInfoSource>
// QtMobility namespace
QTM_USE_NAMESPACE

class  GpsLocation : public  Condition
{
	Q_OBJECT
	Q_PROPERTY(qreal radious READ getRadious WRITE setRadious NOTIFY notifyRadious)


public:
	GpsLocation(ConditionInterface *interface);

	void load(const QByteArray &data);
	QByteArray save() const;

	qreal getRadious() { return radious;}
	void setRadious(qreal rad) { radious = rad; emit notifyRadious(); update();}

	void update();


public slots:
	void positionUpdated(QGeoPositionInfo );


	void areaEntered(const QGeoPositionInfo &);


	void areaExited(const QGeoPositionInfo &);
signals:
	void notifyRadious();

private:

	QGeoAreaMonitor *monitor;
	QGeoCoordinate location;
	qreal radious;
	QGeoPositionInfoSource *source ;
};

//====================================================
class GpsLocationkInterface : public ConditionInterface
{
	Q_OBJECT
	Q_INTERFACES(ConditionInterface)

public:
	virtual QString name() const { return tr("Gps Location"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual GpsLocation *createCondition() { return new GpsLocation(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:GpsLocation.qml"); }
	virtual QUrl icon() const  { return QUrl("qrc:GpsLocation.png"); }
};
//====================================================

#endif // GPSLOCATION_H
