/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    gpslocation.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "gpslocation.h"

#include <QDebug>
GpsLocation::GpsLocation(ConditionInterface *interface) :
	Condition(interface),location(QGeoCoordinate())
{
	source = QGeoPositionInfoSource::createDefaultSource(this);
	monitor = QGeoAreaMonitor::createDefaultMonitor(this);
	connect(monitor, SIGNAL(areaEntered(QGeoPositionInfo)),
			this, SLOT(areaEntered(QGeoPositionInfo)));
	connect(monitor, SIGNAL(areaExited(QGeoPositionInfo)),
			this, SLOT(areaExited(QGeoPositionInfo)));


	if (source) {
		connect(source, SIGNAL(positionUpdated(QGeoPositionInfo )),
				this, SLOT(positionUpdated(QGeoPositionInfo )),Qt::UniqueConnection);
		source->startUpdates();
	}
}

void GpsLocation::positionUpdated(QGeoPositionInfo info)
{
	location = info.coordinate();
	qDebug() << "Position updated:" << info;
}

void GpsLocation::update()
{
	qDebug() << "moje :" << location << " " << radious;
	monitor->setCenter(location);
	monitor->setRadius(radious);
}


void GpsLocation::load(const QByteArray &data)
{
	QDataStream stream(data);
	QGeoCoordinate cor;
	stream >> radious  >> cor;
	monitor->setCenter(cor);
	monitor->setRadius(radious);

	if (source) {
		connect(source, SIGNAL(positionUpdated(QGeoPositionInfo )),
				this, SLOT(positionUpdated(QGeoPositionInfo )),Qt::UniqueConnection);
		source->startUpdates();
	}
}

QByteArray GpsLocation::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);

	stream << radious << monitor->center();
	return data;
}

void GpsLocation::areaEntered(const QtMobility::QGeoPositionInfo &)
{
	setState(true);
}

void GpsLocation::areaExited(const QtMobility::QGeoPositionInfo &)
{
	setState(false);
}

Q_EXPORT_PLUGIN2(gpsarea, GpsLocationkInterface)
