/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    coreinterface.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef COREPLUGIN_H
#define COREPLUGIN_H

#include <QString>
#include <QtPlugin>
#include <QUrl>

/*************************************************************************************************/
// CORE INTERFACE
/*************************************************************************************************/

class CoreInterface : public QObject
{
	Q_OBJECT
	Q_PROPERTY(QString name READ name CONSTANT)
	Q_PROPERTY(QString vendor READ vendor CONSTANT)
	Q_PROPERTY(QString version READ version CONSTANT)

public:

	virtual QString name() const = 0;
	virtual QString vendor() const = 0;
	virtual QString version() const = 0;

	virtual QUrl qmlGUIFile() const = 0;
	virtual QUrl icon() const = 0;
};

/*************************************************************************************************/
// CORE INSTANCE
/*************************************************************************************************/

class CoreInstance : public QObject
{
	Q_OBJECT
	Q_PROPERTY(QString name READ name CONSTANT)

public:
	CoreInstance(CoreInterface *interface) : m_interface(interface) {}

	inline const QString name() const { return m_interface->name(); }

	virtual void load(const QByteArray &data) = 0;
	virtual QByteArray save() const = 0;

protected:
	inline CoreInterface *interface() const { return m_interface; }

private:
	static const QString DefaultInstanceName;
	CoreInterface        *m_interface;
};

/*************************************************************************************************/


#endif // COREPLUGIN_H
