/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    main.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

//import QtQuick 1.0
//import Qt.labs.components.native 1.0
//import com.nokia.extras 1.0
import QtQuick 1.0
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0

Rectangle {
    width: 800
    height: 480
    color: "#000000"
    ButtonColumn {
        id: buttoncolumn1
        x: 80
        y: 93
        width: parent.width - (parent.width * 0.2)
        height: parent.height -(parent.width * 0.2)
        anchors.top: parent.top
        anchors.topMargin: 93
        anchors.right: parent.right
        anchors.rightMargin: 80

        Button {
            id: buttonBatteryEmpty
            text: "Battery Empty"
            width: parent.width
            height: parent.height / 6
            onClicked: {
                setLevelOfLight(0)
            }
        }

        Button {
            id: buttonBatteryCritical
            text: "Battery Critical - 3% or less."
            width: parent.width
            height: parent.height / 6
            onClicked: {
                setLevelOfLight(1)
            }
        }

        Button {
            id: buttonBatteryVeryLow
            width: parent.width
            height: parent.height / 6
            text: "Battery Very Low - 10% or less."
            onClicked: {
                setLevelOfLight(2)
            }
        }

        Button {
            id: buttonBatteryLow
            width: parent.width
            height: parent.height / 6
            text: "Battery Low - 40% or less."
            onClicked: {
                setLevelOfLight(3)
            }
        }
        Button {
            id: buttonBatteryOk
            width: parent.width
            height: parent.height / 6
            text: "Battery Ok - above 40%"
            onClicked: {
                setLevelOfLight(4)
            }
        }
        Button {
            id: buttonBatteryFull
            width: parent.width
            height: parent.height / 6
            text: "Battery Full - Battery level 100%. "
            onClicked: {
                setLevelOfLight(5)
            }
        }
    }

    Text {
        id: text1
        x: 80
        y: 37
        width: 66
        height: 36
        color: "#ffffff"
        text: qsTr("Current level:")
        font.pixelSize: 36

        Text {
            id: textLevel
            x: 221
            y: 0
            width: 431
            height: 41
            color: "#ffffff"
            text: " "
            font.pixelSize: 36
        }
    }

    Connections {
        target: Instance
        onNotifyBatteryStatusFromMobile: changeText(Instance.batteryStatusFromMobile)
        ignoreUnknownSignals: true
    }
    Component.onCompleted: {
        changeText(Instance.getBatteryStatusFromMobile());
        checkButton(Instance.batterySelectedStatus);
    }


    function checkButton(param)
    {
        switch(param) {
        case 0 : buttoncolumn1.checkedButton = buttonBatteryEmpty; break;
        case 1 : buttoncolumn1.checkedButton = buttonBatteryCritical; break;
        case 2 : buttoncolumn1.checkedButton = buttonBatteryVeryLow; break;
        case 3 : buttoncolumn1.checkedButton = buttonBatteryLow; break;
        case 4 : buttoncolumn1.checkedButton = buttonBatteryOk; break;
        case 5 : buttoncolumn1.checkedButton = buttonBatteryFull; break;
            //default : textLevel.text = "Error"; break;
        }
    }


    function changeText(param)
    {
        switch(param) {
        case 0 : textLevel.text = "Battery Empty"; break;
        case 1 : textLevel.text = "Battery Critical"; break;
        case 2 : textLevel.text = "Battery Very Low"; break;
        case 3 : textLevel.text = "Battery Low"; break;
        case 4 : textLevel.text = "Battery Ok"; break;
        case 5 : textLevel.text = "Battery Full"; break;
        default : textLevel.text = "Error"; break;
        }
    }



    function setLevelOfLight(value)
    {
        Instance.batterySelectedStatus = value;
    }
}
