/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    profilechanger.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "profilechanger.h"
#include <QDebug>
#include <QtDBus/QDBusInterface>
#include <QDBusReply>
ProfileChanger::ProfileChanger(ActionInterface *interface) :
	Action(interface),DBUSChangeProfile(new QDBusInterface("com.nokia.profiled",
														   "/com/nokia/profiled",
														   "com.nokia.profiled",
														   QDBusConnection::sessionBus(),this)),//session bus musi byt
	lastProfile("general"),
	newProfile("general")
{
}
//http://sites.google.com/site/alexystems/scripts/maemo/scriptsthatincreaseyourn900suserexperience
void ProfileChanger::start()
{
	if (!DBUSChangeProfile->isValid()) {
		qDebug() << "Cannotct conect to D-BUS";
	} else {
		//send message
		qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "zmena profilu";
		QDBusReply<QString> profileNameReply = DBUSChangeProfile->call("get_profile");
		if (profileNameReply.isValid())
			lastProfile = profileNameReply.value();
		qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "last je " << lastProfile;
		DBUSChangeProfile->call(QLatin1String("set_profile"),newProfile);//silent general
	}
}

void ProfileChanger::stop()
{
	if (!DBUSChangeProfile->isValid()) {
		qDebug() << "Cannotct conect to D-BUS";
	} else {
		//send message
		qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "stop";
		qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "last je " << lastProfile;
		DBUSChangeProfile->call(QLatin1String("set_profile"),lastProfile);//silent general
	}
}



void ProfileChanger::doAction()
{
	start();
}

void ProfileChanger::load(const QByteArray &data)
{
	QDataStream stream(data);
	stream >> newProfile;

}

QByteArray ProfileChanger::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);
	stream << newProfile;

	return data;
}

void ProfileChanger::stopAction()
{
	stop();
}


Q_EXPORT_PLUGIN2(profilechanger, ProfileChangerInterface)

