/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    ProfileDialog.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

import QtQuick 1.0
import Qt.labs.components.native 1.0


Dialog {
    id: root
    property string windowTitle: qsTr("Create New Profile")
    property string acceptButtonText: qsTr("Create")

    function show()
    {
        open()
        nameEdit.focus = true
    }

    function profileName()
    {
        return nameEdit.text
    }

    function setProfileName(name)
    {
        nameEdit.text = name
    }

    anchors.centerIn: parent
    title: [
        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            font.bold: true
            color: "white"
            text: root.windowTitle
        }
    ]
    content: Column {
        anchors.horizontalCenter: parent.horizontalCenter

        //spacer
        Rectangle {
            width: parent.width
            height: 50
            color: "transparent"
        }

        Row {
            Text {
                text: qsTr("Profile Name: ")
                color: "grey"
            }

            TextField {
                id: nameEdit
            }
        }

        //spacer
        Rectangle {
            width: parent.width
            height: 50
            color: "transparent"
        }
    }

    buttons:   [
        Button {
            enabled: Profiler.verifyProfileRename(nameEdit.text)
            anchors.left: parent.left
            width: 200
            anchors.leftMargin: 100
            text: root.acceptButtonText
            onClicked: {
                root.accept();
            }
        },
        Button {
            anchors.right: parent.right
            width: 200
            anchors.rightMargin: 100
            text: qsTr("Cancel");
            onClicked: {
                root.reject();
            }
        }
    ]

}
