/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    HeaderView.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

import Qt 4.7
import QtQuick 1.0
import Qt.labs.components.native 1.0

Rectangle {
    id: headerView
    property string applicationName: ""

    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    height: 50
    color: "black"

    function backsteppingImage() {
        var source

        if (toolbar.views[toolbar.current].backsteppingExits) {
            if (backsteppingArea.pressed) {
                source = "qrc:/icons/close_pressed.png"
            } else {
                source = "qrc:/icons/close.png"
            }
        } else {
            if (backsteppingArea.pressed) {
                source = "qrc:/icons/back_pressed.png"
            } else {
                source = "qrc:/icons/back.png"
            }
        }
        return source
    }


    function nimage() {
        if(ncarea.pressed) {
            return "qrc:/icons/add_big_pressed.png"
        }
        else {
            return "qrc:/icons/add_big.png"
        }
    }

    function addNProfile() {
        if (toolbar.views[toolbar.current].backsteppingExits) {
            return true;
        }
        return false;
    }

    Image {
        anchors.fill: parent
        source: "qrc:/icons/toolbaritem.png"
    }

    Text {
        anchors.centerIn: parent
        font.pointSize: Math.round(headerView.height / 2.5)
        color: "lightgray"
        text: applicationName
    }


    Image {
        id: addNewProfile
        visible: addNProfile()

        anchors.right: parent.right
        anchors.rightMargin: 80
        anchors.verticalCenter: parent.verticalCenter

        source: nimage()
        MouseArea {
            id: ncarea

            width: parent.width + 20
            height: parent.height + 20

            anchors.centerIn: parent

            onClicked: {
                profileDialog.setProfileName("");
                profileDialog.show()
            }
        }
    }

    ProfileDialog {
        id: profileDialog

        onAccepted: {
            Profiler.addProfile(profileName())
        }
    }

    Image {
        id: backstepping
        source: backsteppingImage()
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.verticalCenter: parent.verticalCenter

        MouseArea {
            id: backsteppingArea

            // Make mouse area bigger than the button to make it easier
            // to hit with a finger
            anchors.centerIn: parent
            width: parent.width + 20
            height: parent.height + 20

            onClicked: {
                if (toolbar.views[toolbar.current].backsteppingExits) {
                    Qt.quit()
                } else {
                    toolbar.views[toolbar.current].backstep()
                }
            }
        }
    }
}
