/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    CoverFlow.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

import QtQuick 1.0
import "dynamic.js" as DymanicCreator


//COVERFLOW
Rectangle {
    id: coverFlow

    property string type

    property int itemWidth
    property int itemHeight

    property variant listModel

    signal indexChanged(int index)

    // DELEGATE - every plugin
    Component {
        id: appDelegate

        // flipable rectangle
        Flipable {
            id: myFlipable

            property bool flipped: false

            width: itemWidth;
            height: itemHeight

            z: PathView.z

            scale: PathView.iconScale

            // change color on click
            function itemClicked()
            {
                if(PathView.isCurrentItem) {
                    if(type == "actions")
                        Profiler.addCurrentProfileAction(index)
                    else
                        Profiler.addCurrentProfileCondition(index)

                    switchState2()
                }
                else if(myPathView.interactive) {
                    myPathView.currentIndex = index
                }
            }


            // get icon url based on its index
            function getIcon()
            {
                if (type == "actions") {
                    if (index >= Profiler.actionPluginCount()) {
                        return "";
                    }
                } else {
                    if (index >= Profiler.conditionPluginCount()) {
                        return "";
                    }
                }

                return type == "actions" ? Profiler.actionPluginIcon(index) :
                                           Profiler.conditionPluginIcon(index)
            }

            // PLUGIN FRONT
            front: Rectangle {
                smooth: true

                width: itemWidth
                height: itemHeight

                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter

                gradient: Gradient {
                    GradientStop { position: 0.0; color: "grey" }
                    GradientStop { position: 1.0; color: "white" }
                }

                radius: 8

                // ICON
                Image {
                    id: myIcon

                    anchors.fill: parent

                    source: getIcon()
                    smooth: true

                    // move by keys
                    Keys.onReturnPressed: itemClicked()

                    // or by clicking
                    MouseArea {
                        anchors.fill: parent
                        onHoveredChanged:  {
                            if(parent.opacity == 1)
                                parent.opacity = 0.8
                            else
                                parent.opacity = 1
                        }

                        onClicked: itemClicked()
                    }


                    // PLUGIN NAME
                    Text {
                        anchors.top: parent.top
                        anchors.topMargin: 20
                        anchors.horizontalCenter: parent.horizontalCenter

                        color: "white"

                        text: name
                    }
                }
            }

        }// end of flippable
    }// end of component

    // PATHVIEW
    PathView {
        id: myPathView

        property double angle: 0

        // move on keys
        Keys.onRightPressed: if (!moving && interactive) incrementCurrentIndex()
        Keys.onLeftPressed: if (!moving && interactive) decrementCurrentIndex()

        anchors.fill: parent
        preferredHighlightBegin: 0.5
        preferredHighlightEnd: 0.5
        focus: true
        interactive: true

        model: listModel

        delegate: appDelegate

        path: Path {
            startX: 0
            startY: coverFlow.height / 2
            PathAttribute { name: "z"; value: 0 }
            PathAttribute { name: "angle"; value: 60 }
            PathAttribute { name: "iconScale"; value: 0.4 }
            PathLine { x: coverFlow.width / 2; y: coverFlow.height / 2;  }
            PathAttribute { name: "z"; value: 100 }
            PathAttribute { name: "angle"; value: 0 }
            PathAttribute { name: "iconScale"; value: 1.0 }
            PathLine { x: coverFlow.width; y: coverFlow.height / 2; }
            PathAttribute { name: "z"; value: 0 }
            PathAttribute { name: "angle"; value: -60 }
            PathAttribute { name: "iconScale"; value: 0.4 }
        }
    }
    Component.onCompleted: {
        myPathView.currentIndexChanged.connect(function(){
                                                   indexChanged(myPathView.currentIndex);
                                               })
    }
}
