/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    ActionDelegate.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

import Qt 4.7
import QtQuick 1.0
import Qt.labs.components.native 1.0


// DETAIL LIST ACTION - delegate

Component {
    id: delegate

    BorderImage {

        width: cond.width
        height: 50

        border.bottom: 0
        border.top: 0
        border.left: 0
        border.right: 2

        source: lsclicked ? "qrc:/icons/listitem_small_pressed.png" : "qrc:/icons/listitem_smal2l.png"

        property bool lsclicked: false

        //        function getPluginStatus() {
        //            return model.modelData.active ? "qrc:/icons/greenStone.png" : "qrc:/icons/redStone.png"
        //        }

        // PLUGIN name
        Text {
            anchors.left: parent.left
            anchors.leftMargin: 15
            anchors.verticalCenter: parent.verticalCenter
            text: name
            font.pixelSize: 22
            style: Text.Raised
        }

        // LOAD PLUGIN GUI
        MouseArea {
            anchors.fill: parent
            onHoveredChanged: {
                parent.lsclicked = !parent.lsclicked
            }

            onClicked: {
                pluginView.loadPlugin(Profiler.currentProfileActionPluginQmlGUI(index))
                detailListView.switchState3()
            }
        }// end of mousearea


        // STATUS NOTIFICATION
        //        Image {
        //            width: 20
        //            height: 20

        //            source: getPluginStatus()

        //            anchors.verticalCenter: parent.verticalCenter
        //            anchors.right: parent.right
        //            anchors.rightMargin: 80
        //            z: 1

        //        }


        // DELETE BUTTON
        Image {
            source: "qrc:/icons/close.png"
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            anchors.rightMargin: 5
            z: 1

            MouseArea {
                anchors.fill: parent

                property bool delClickeda: false

                onHoveredChanged: {
                    delClickeda = !delClickeda

                    if(delClickeda)
                        parent.source = "qrc:/icons/close_pressed.png"
                    else
                        parent.source = "qrc:/icons/close.png"
                }

                // deleting condition or action
                onClicked: {
                    detailView.selectedToDelete = index
                    qdact.open()
                }
            }// end of mousearea
        }// end of button

    }// end of borderimage
}

