/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    testcondition.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef TESTCONDITION_H
#define TESTCONDITION_H

#include "../interface/conditioninterface.h"

/*************************************************************************************************/
// TEST CONDITION 1
/*************************************************************************************************/

class TestCondition1 : public Condition
{
public:
	TestCondition1(class TestCondition1Interface *interface);

	virtual void load(const QByteArray &data) { Q_UNUSED(data); return; }
	virtual QByteArray save() const { return QByteArray(); }
};

/*************************************************************************************************/
// TEST CONDITION 1 INTERFACE
/*************************************************************************************************/

class TestCondition1Interface : public ConditionInterface
{
public:
	virtual QString name() const { return "TEST CONDITION 1"; }
	virtual QString vendor() const { return "NONE"; }
	virtual QString version() const { return "0.0"; }

	virtual TestCondition1 *createCondition() { return new TestCondition1(this); }

	virtual QUrl qmlGUIFile() const { return QUrl::fromLocalFile("qml/test/testcondition1.qml"); }
};

/*************************************************************************************************/
// TEST CONDITION 2
/*************************************************************************************************/

class TestCondition2 : public Condition
{
public:
	TestCondition2(class TestCondition2Interface *interface);

	virtual void load(const QByteArray &data) { Q_UNUSED(data); return; }
	virtual QByteArray save() const { return QByteArray(); }
};

/*************************************************************************************************/
// TEST CONDITION 2 INTERFACE
/*************************************************************************************************/

class TestCondition2Interface : public ConditionInterface
{
public:
	virtual QString name() const { return "TEST CONDITION 2"; }
	virtual QString vendor() const { return "NONE"; }
	virtual QString version() const { return "0.0"; }

	virtual TestCondition2 *createCondition() { return new TestCondition2(this); }

	virtual QUrl qmlGUIFile() const { return QUrl::fromLocalFile("qml/test/testcondition2.qml"); }
};

/*************************************************************************************************/

#endif // TESTCONDITION_H
