/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    testaction.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef TESTACTION_H
#define TESTACTION_H

#include "../interface/actioninterface.h"
#include <QDebug>

/*************************************************************************************************/
// TEST ACTION 1
/*************************************************************************************************/

class TestAction1 : public Action
{
public:
	TestAction1(class TestAction1Interface *interface);

	virtual void doAction() { qDebug() << "DOING" << interface()->name(); }

	virtual void load(const QByteArray &data) { Q_UNUSED(data); return; }
	virtual QByteArray save() const { return QByteArray(); }
};

/*************************************************************************************************/
// TEST ACITON 1 INTERFACE
/*************************************************************************************************/

class TestAction1Interface : public ActionInterface
{
public:
	virtual QString name() const { return "TEST ACTION 1"; }
	virtual QString vendor() const { return "NONE"; }
	virtual QString version() const { return "0.0"; }

	virtual TestAction1 *createAction() { return new TestAction1(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:qml/test/testaction1.qml"); }
};

/*************************************************************************************************/
// TEST ACTION 2
/*************************************************************************************************/

class TestAction2 : public Action
{
public:
	TestAction2(class TestAction2Interface *interface);

	virtual void doAction() { qDebug() << "DOING" << interface()->name(); }

	virtual void load(const QByteArray &data) { Q_UNUSED(data); return; }
	virtual QByteArray save() const { return QByteArray(); }
};

/*************************************************************************************************/
// TEST ACITON 2 INTERFACE
/*************************************************************************************************/

class TestAction2Interface : public ActionInterface
{
public:
	virtual QString name() const { return "TEST ACTION 2"; }
	virtual QString vendor() const { return "NONE"; }
	virtual QString version() const { return "0.0"; }

	virtual TestAction2 *createAction() { return new TestAction2(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:qml/test/testaction2.qml"); }
};

/*************************************************************************************************/

#endif // TESTACTION_H
