#ifndef CUSTOMITEM_H
#define CUSTOMITEM_H
#include "listmodel.h"
#include <QDebug>

class CustomItem : public ListItem
{
  Q_OBJECT

public:
  enum Roles {
    NameRole = Qt::UserRole+1,
    ReadyRole
  };

public:
  CustomItem(QObject *parent = 0): ListItem(parent) {}
  explicit CustomItem(const QString &name, QObject *parent = 0);
  QVariant data(int role) const;
  bool setData(int role, const QVariant &data);
  QHash<int, QByteArray> roleNames() const;
  void setPrice(qreal price);
  inline QString id() const { return m_name; }
  inline QString name() const { return m_name; }


signals:
  void readyChanged();

private:
  QString m_name;
};

class TestObject : public QObject
{
	Q_OBJECT
	Q_PROPERTY(QString name READ testName WRITE setTestName NOTIFY testNameChanged)

public:
	TestObject(const QString &name) : m_testName(name) {}

	QString testName() const { return m_testName; }
	void setTestName(const QString &n) { m_testName = n; emit testNameChanged(); }

signals:
	void testNameChanged();

private:
	QString m_testName;
};

#endif // CUSTOMITEM_H
