/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    configmanipulator.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include <QSettings>
#include <QApplication>
#include "configreader.h"
#include "configwriter.h"
#include "../core/profilercontroller.h"
#include "configmanipulator.h"
#include <QDebug>
#include <QFile>

/*************************************************************************************************/

static const QString ConfigName = "config";

/*************************************************************************************************/
// CONFIG MANIPULATOR
/*************************************************************************************************/

ConfigManipulator::ConfigManipulator() :
	d(new ConfigManipulatorData)
{
	qApp->setApplicationName("Maemo-Profiler");
	qApp->setApplicationVersion("0.1");
	qApp->setOrganizationName("FIT VUTBR");
	qApp->setOrganizationDomain("fit.vutbr.cz");
}

/*************************************************************************************************/

ConfigManipulator::~ConfigManipulator()
{
	delete d;
}

/*************************************************************************************************/

bool ConfigManipulator::load(QObjectList &profiles)
{
	QSettings    settings;
	QString      config = settings.value(ConfigName).toString();

//	QFile file("/home/ris/cfg");
//	file.open(QIODevice::ReadOnly);
//	QString config = file.readAll();
	ConfigReader configReader(config);

	if (!configReader.read()) {
		d->error = configReader.errorString();
		return false;
	}

//	qDebug() << configReader.profiles() << configReader.errorString();
	profiles = configReader.profiles();

	return true;
}

/*************************************************************************************************/

bool ConfigManipulator::create()
{
	return save(QObjectList());
}

/*************************************************************************************************/

bool ConfigManipulator::loadOrCreate(QObjectList &profiles)
{
	if (!load(profiles)) {
		return create();
	}

	return true;
}

/*************************************************************************************************/

bool ConfigManipulator::save(const QObjectList &profiles) const
{
	QSettings    settings;
	QString      config;
	ConfigWriter configWriter(&config);

	configWriter.write(profiles);

//	QFile file("/home/ris/cfg");
//	file.open(QIODevice::WriteOnly);
//	file.write(config.toLocal8Bit());
	settings.setValue(ConfigName, config);

	return true;
}

/*************************************************************************************************/
