#include "LyricWikiDownloader.h"
#include <QTextDocument>
#include <QDebug>

const QString LyricWikiDownloader::rooturl("http://lyrics.wikia.com");

string LyricWikiDownloader::toProviderCode(const string &artist, const string &track) const
{
    QString artist_www, track_www;
    artist_www = QString::fromStdString(artist).trimmed().replace(' ', '_');
    track_www = QString::fromStdString(track).trimmed().replace(' ', '_');
    return (QString(rooturl + "/%1:%2").arg(artist_www, track_www)).toStdString();
}

bool LyricWikiDownloader::parse()
{
    qDebug() << "parsing\n";
    istringstream temp(buff.str());
    buff.str("");
    string line;
    QString line_QStr;
    qDebug() << "variables set up\n";
    while (temp.good())
    {
        getline(temp, line);
        qDebug() << "Got line = " << QString::fromStdString(line);
        if ((line_QStr = QString::fromStdString(line)).contains("<div class='lyricbox\'>"))
        {
            qDebug() << "Line contains lyricbox!!\n";
            int lyricsstart = line_QStr.indexOf("</div>") + 6;
            int lyricslength = line_QStr.indexOf("<!-- ") - lyricsstart;
            /*copy(line_QStr.begin() + line_QStr.indexOf("</div>") + 6, // + length of "</div>"
                 line_QStr.begin() + line_QStr.indexOf("<!-- "),
                 lyrics_qstr.begin());*/
            lyrics_qstr = line_QStr.mid(lyricsstart, lyricslength);
            break;
        }
    }
    if ( !temp.good() ) return false; // something went wrong

    QTextDocument lyricsHtml;
    lyricsHtml.setHtml(lyrics_qstr);
    lyrics_qstr = lyricsHtml.toPlainText();
    return true;
}
