#include "AZLyricsDownloader.h"
#include <QTextDocument>

const QString AZLyricsDownloader::rooturl("http://azlyrics.com/lyrics");
const QRegExp AZLyricsDownloader::endcomment("<!-- end of lyrics -->");
const QRegExp AZLyricsDownloader::startcomment("<!-- start of lyrics -->");

string AZLyricsDownloader::toProviderCode(const string& artist, const string& track) const
{
    QString artist_www, track_www;
    artist_www = QString::fromStdString(artist).toLower().remove(QRegExp("^the")).remove(QRegExp("\\W"));
    track_www = QString::fromStdString(track).toLower().remove(QRegExp("\\W"));

    return (rooturl + "/" + artist_www + "/" + track_www + ".html").toStdString();

}

bool AZLyricsDownloader::parse()
{
    istringstream temp(buff.str());
    buff.str("");
    string line;
    QString lyrics_QStr, line_QStr;
    while ( temp.good() ) // looking for comment about starting lyrics
    {
        getline(temp, line);
        if (QString::fromStdString(line).contains(startcomment)) break;
    }
    if ( !temp.good() ) return false; // something went wrong
    // get every line until endcomment
    while ( temp.good() )
    {
        getline(temp, line);
        if (( line_QStr = QString::fromStdString(line) ).contains(endcomment)) break;
        lyrics_QStr += line_QStr;
        //lyrics_QStr += line_QStr.remove(QRegExp("<br[ ]{0,1}[/]{0,1}>"));
        //lyrics_QStr += " \n";
    }
    if ( !temp.good() ) return false; // something went wrong, returning blank string


    QTextDocument lyricsHtml;
    lyricsHtml.setHtml(lyrics_QStr);
    lyrics_qstr = lyricsHtml.toPlainText();
    return true;
}
