/* File: settings.cpp
 *
 * This file is part of MaeLyrica.
 *
 * Copyright (C) 2012 Marcin Mielniczuk.
 *
 * MaeLyrica is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, version 3 of the License.
 *
 * MaeLyrica is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *  along with MaeLyrica.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "settings.h"

void Settings::addRecentSearch(QString search)
{
    QStringList temp(search);
    temp << getRecentSearches();
    temp.removeDuplicates();
    setRecentSearches(temp);
}

void Settings::restoreDefaults()
{
    setRecentSearches();
    beginGroup("saves");
    setValue("autoScan", true);
    endGroup();
}
