###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QListView, QPushButton, 
                          QMainWindow, QHBoxLayout, QVBoxLayout, QWidget)
from PyQt4.QtCore import Qt
import sip

# third-party modules
import config as c

# program modules 
from ui.ui_view_exercise_window import Ui_ViewExerciseWindow

class ViewExerciseWindow(QMainWindow, Ui_ViewExerciseWindow):

    def __init__(self, filename, parent=None, database=None):
        super(ViewExerciseWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.example_media_player.setFilename(filename)
        self.config = c.Config()
        self.db = database
        self.reflowWidgets()

        QApplication.desktop().resized.connect(self.reflowWidgets)

    def reflowWidgets(self):
        try:
            sip.delete(self.central_widget.layout())
        except TypeError:
            pass

        screen_geometry = QApplication.desktop().screenGeometry()
        if screen_geometry.width() > screen_geometry.height():
            self.central_widget.setLayout(QVBoxLayout())

            top_h_box = QHBoxLayout()
            top_h_box.addWidget(self.example_media_player)

            bottom_h_box = QHBoxLayout()
            bottom_h_box.addWidget(self.duration_value_button)
            bottom_h_box.addWidget(self.frequency_value_button)
            bottom_h_box.addWidget(self.intensity_value_button)
            bottom_h_box.addWidget(self.equipment_value_button)

            self.central_widget.layout().addLayout(top_h_box)
            self.central_widget.layout().addLayout(bottom_h_box)
        else:
            self.central_widget.setLayout(QVBoxLayout())


            self.central_widget.layout().addWidget(self.example_media_player)
            self.central_widget.layout().addWidget(self.duration_value_button)
            self.central_widget.layout().addWidget(self.frequency_value_button)
            self.central_widget.layout().addWidget(self.intensity_value_button)
            self.central_widget.layout().addWidget(self.equipment_value_button)
