###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QAbstractItemView, QPushButton, 
                          QMainWindow, QMenu)
from PyQt4.QtMaemo5 import QMaemo5EditBar
from PyQt4.QtCore import (Qt, pyqtSignature)

# third-party modules
import config as c 

# program modules 
from ui.ui_sessions_window import Ui_SessionsWindow
import exercises_window  as ew
import target_areas_window as taw
import session_window as sw
import session_dialog as rd

class SessionsWindow(QMainWindow, Ui_SessionsWindow):

    def __init__(self, parent=None, database=None):
        super(QMainWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.setupEditBar()
        self.config = c.Config()
        self.db = database
        self.setupListView()

        self.customContextMenuRequested.connect(self.openMenu)

    def setupEditBar(self):
        self.delete_button = QPushButton('Delete')
        self.edit_bar = QMaemo5EditBar('Select Sessions', self)
        self.edit_bar.addButton(self.delete_button)
        self.edit_bar.setVisible(False)

        self.central_widget.layout().insertWidget(0, self.edit_bar)

    def closeEvent(self, event):
        if self.edit_bar.isVisible():
            self.exitFullScreen()
            event.ignore()
        else:
            event.accept()

    def setupListView(self):
        self.model = self.db.sessions_model
        self.sessions_list_view.setModel(self.model)
        self.sessions_list_view.setModelColumn(1)

    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        self.parent().setFitnessWindow()
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()

    @pyqtSignature("bool")
    def on_target_areas_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'target_areas'
        self.parent().setFitnessWindow()
        target_areas_window = taw.TargetAreasWindow(self.parent(), self.db)
        target_areas_window.show()
        self.hide()

    @pyqtSignature('bool')
    def on_delete_sessions_action_triggered(self, checked):
        self.sessions_list_view.blockSignals(True)
        def deleteSessions():
            indexes = []
            for index in self.sessions_list_view.selectedIndexes():
                try:
                    if index.row() > indexes[-1].row():
                        indexes.insert(0, index)
                    else:
                        indexes.append(index)
                except IndexError:
                    indexes.append(index)

            for index in indexes:
                self.model.removeRow(index.row())

            self.exitFullScreen()

        self.sessions_list_view.setSelectionMode(QAbstractItemView.MultiSelection)
        self.edit_bar.setVisible(True)
        self.new_session_button.setVisible(False)

        self.showFullScreen()

        self.delete_button.clicked.connect(deleteSessions)

    @pyqtSignature('QModelIndex')
    def on_sessions_list_view_clicked(self, index):
        s_name = index.data().toString()
        s_id = index.row()
        s_id = index.model().record(index.row()).field('s_id').value().toString()
        session_window = sw.SessionWindow(s_name, s_id, self, self.db)
        session_window.show()

    def on_new_session_button_pressed(self):
        session_dialog = rd.SessionDialog(self, self.db)
        session_dialog.show()

    def exitFullScreen(self):
        self.sessions_list_view.clearSelection()
        self.sessions_list_view.setSelectionMode(QAbstractItemView.SingleSelection)
        self.new_session_button.setVisible(True)
        self.edit_bar.setVisible(False)
        self.showNormal()
        self.sessions_list_view.blockSignals(False)

    def openMenu(self, position):
        menu = QMenu(self)
        edit_action = menu.addAction('Edit')
        delete_action = menu.addAction('Delete')

        action = menu.exec_(self.mapToGlobal(position))

        if action == edit_action:
            index = self.sessions_list_view.currentIndex()
            name = self.model.record(index.row()).value('s_name')

            session_dialog = rd.SessionDialog(self, self.db, name)

            description = self.model.record(index.row()).value('s_description')

            session_dialog.name_line_edit.setText(name.toString())
            session_dialog.description_text_edit.setHtml(description.toString())
            session_dialog.show()
        elif action == delete_action:
            self.model.removeRow(self.sessions_list_view.currentIndex().row())

