###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

from PyQt4.QtSql import (QSqlRelationalTableModel)
from PyQt4.QtGui import (QPixmap)
from PyQt4.QtCore import (Qt, QTimer, QVariant)

from PyQt4.phonon import Phonon
import sip

class ExercisesRelationalModel(QSqlRelationalTableModel):
    def data(self, index, role=Qt.DisplayRole):
        if role == Qt.DisplayRole:
            record = self.record(index.row())
            name = record.value("ex_name").toString()
            description = record.value("ex_description").toString()

            return QVariant("<big>%s</big><br>"
                            "<small>%s</small>" %(name, description))

        if role == Qt.DecorationRole:
            record = self.record(index.row())
            filename = record.value("ex_media").toString()
            pixmap = QPixmap(filename)

            if pixmap.isNull():
                return None
            else:
                return pixmap.scaled(48, 48)

        return super(ExercisesRelationalModel, self).data(index, role)
