###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

from PyQt4.QtGui import (QAbstractTextDocumentLayout, QApplication, QPalette, 
                         QStyle, QStyledItemDelegate, QStyleOptionViewItem, 
                         QStyleOptionViewItemV4, QTextDocument)
from PyQt4.QtCore import QString

class ExercisesDelegate(QStyledItemDelegate):

    def paint(self, painter, option, index):
        optionV4 = QStyleOptionViewItemV4(option)
        optionV4.decorationPosition = QStyleOptionViewItem.Right

        self.initStyleOption(optionV4, index)

        try:
            style = optionV4.widget.style()
        except AttributeError:
            style = QApplication.style()

        doc = QTextDocument()
        doc.setHtml(optionV4.text)

        optionV4.text = QString()
        style.drawControl(QStyle.CE_ItemViewItem, optionV4, painter)

        ctx = QAbstractTextDocumentLayout.PaintContext()

        if optionV4.state and QStyle.State_Selected:
            ctx.palette.setColor(QPalette.Text,
                                 optionV4.palette.color(QPalette.Active,
                                                        QPalette.HighlightedText))

        textRect = style.subElementRect(QStyle.SE_ItemViewItemText, optionV4)
        painter.save()
        painter.translate(textRect.topLeft())
        painter.setClipRect(textRect.translated(-textRect.topLeft()))
        doc.documentLayout().draw(painter, ctx)
        painter.restore()
