###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QDialog, QPushButton, QDialogButtonBox)
from PyQt4.QtCore import (pyqtSignature, Qt)

# program modules 
from ui.ui_settings_dialog import Ui_SettingsDialog
from ui.ui_exercises_dialog import Ui_ExercisesDialog

class ExercisesDialog(QDialog, Ui_ExercisesDialog):

    def __init__(self, parent=None, database=None):
        super(ExercisesDialog, self).__init__(parent)

        self.setupUi(self)
        self.db = database
        self.exercises_list_view.setModel(self.db.exercises_model())
        self.exercises_list_view.setModelColumn(1)

        done_button = QPushButton('Done')
        self.button_box.addButton(done_button, QDialogButtonBox.AcceptRole)
