###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QMainWindow, QListView, QMenu)
from PyQt4.QtCore import (pyqtSignature, pyqtSignal, Qt)

# program modules 
from ui.ui_target_areas_window import Ui_TargetAreasWindow
from ui.ui_routine_window import Ui_RoutineWindow
import exercises_window as ew
import exercises_dialog as ed

class RoutineWindow(QMainWindow, Ui_RoutineWindow):

    def __init__(self, r_name, r_id, parent=None, database=None):
        super(RoutineWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.setWindowTitle(r_name)
        self.db = database
        self.r_id = r_id
        self.r_name = r_name
        self.setupRoutineExercisesListView()

        self.customContextMenuRequested.connect(self.openMenu)

    def setupRoutineExercisesListView(self):
        self.model = self.db.routine_exercises_model(self.r_name)
        self.routine_exercise_list_view.setModel(self.model)
        self.routine_exercise_list_view.setModelColumn(1)

    def openMenu(self):
        pass

    @pyqtSignature("bool")
    def on_add_exercises_action_triggered(self, checked):

        self.exercises_dialog = ed.ExercisesDialog(self, self.db)
        self.exercises_dialog.show()
        self.exercises_dialog.accepted.connect(self.addRoutineExercises)

    def addRoutineExercises(self):
        ex_ids = []
        for index in self.exercises_dialog.exercises_list_view.selectedIndexes():
            ex_ids.append(index.model().record(index.row()).value('ex_id').toString())

        for ex_id in ex_ids:
            self.db.editRoutineExercise(self.r_id, ex_id)

        self.setupRoutineExercisesListView()
