# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QHBoxLayout, QLabel, QPushButton, 
                         QMainWindow, QVBoxLayout, QWidget) 
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)
import sip

# third-party modules
import config as c

# program modules 
from database import Database
from ui.ui_welcome_window import Ui_WelcomeWindow
import exercises_window as ew
import routines_window as ww
import target_areas_window as taw
import meals_window as mw
import settings_dialog as sd

class WelcomeWindow(QMainWindow, Ui_WelcomeWindow):
    def __init__(self, parent=None):
        super(QMainWindow, self).__init__(parent)

        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

        self.setupUi(self)
        self.db = Database(self)
        self.loadConfigOptions()
        self.reflowWidgets()

        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), 
                     self.reflowWidgets)

    def loadConfigOptions(self):
        self.config = c.Config()
        self.setOrientation()
        self.setFitnessWindow()
        self.setNutritionWindow()

    def setOrientation(self):
        if self.config.interface['orientation'].lower() == 'auto':
            self.setAttribute(Qt.WA_Maemo5AutoOrientation)
        elif self.config.interface['orientation'].lower() == 'landscape':
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation)
        elif self.config.interface['orientation'].lower() == 'portrait':
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation)

    def setFitnessWindow(self):
        if self.config.interface['remember-last-fitness']:
            if self.config.interface['last-fitness'] == 'exercises':
                self.fitness_window = ew.ExercisesWindow(self, self.db)
            elif self.config.interface['last-fitness'] == 'routines':
                self.fitness_window = ww.RoutinesWindow(self, self.db)
            elif self.config.interface['last-fitness'] == 'target_areas':
                self.fitness_window = taw.TargetAreasWindow(self, self.db)
        else:
            self.fitness_window = ew.ExercisesWindow(self, self.db)

    def setNutritionWindow(self):
        self.nutrition_window = mw.MealsWindow(self, self.db)

    def reflowWidgets(self):
        try:
            sip.delete(self.central_widget.layout())
        except TypeError:
            pass

        screen_geometry = QApplication.desktop().screenGeometry()
        if screen_geometry.width() > screen_geometry.height():
            self.central_widget.setLayout(QHBoxLayout())
        else:
            self.central_widget.setLayout(QVBoxLayout())

        self.central_widget.layout().addWidget(self.fitness_button)
        self.central_widget.layout().addWidget(self.nutrition_button)
        self.central_widget.layout().addWidget(self.progress_button)
        self.central_widget.layout().addWidget(self.calendar_button)

    def on_fitness_button_clicked(self):
        self.fitness_window.show()

    def on_nutrition_button_clicked(self):
        self.nutrition_window.show()

    @pyqtSignature("bool")
    def on_settings_action_triggered(self, checked):
        settings_dialog = sd.SettingsDialog(self)
        settings_dialog.show()
    

if __name__ == '__main__':
    app = QApplication(sys.argv)
    app.setApplicationName('MaeGym')
    welcome_window = WelcomeWindow()
    welcome_window.show()
    sys.exit(app.exec_())
