# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QListView, QPushButton, 
                          QMainWindow, QVBoxLayout, QWidget)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c

# program modules 
from ui_exercises_window import Ui_ExercisesWindow
import workouts_window as ww
import new_exercise_wizard as newiz
import target_areas_window as taw

class ExercisesWindow(QMainWindow, Ui_ExercisesWindow):

    def __init__(self, parent=None, database=None):
        super(QMainWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.setupTableView()

    def setupTableView(self):
        self.exercises_list_view.setModel(self.db.exercises_model)
        self.exercises_list_view.setModelColumn(1)

    @pyqtSignature("bool")
    def on_workouts_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'workouts'
        workouts_window = ww.WorkoutsWindow(self.parent(), self.db)
        workouts_window.show()
        self.hide()

    @pyqtSignature("bool")
    def on_target_areas_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'target_areas'
        target_areas_window = taw.TargetAreasWindow(self.parent(), self.db)
        target_areas_window.show()
        self.hide()

    def on_new_exercise_button_pressed(self):
        new_exercise_wizard = newiz.NewExerciseWizard(self, self.db)
        new_exercise_wizard.show()
