# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QPushButton, 
                          QMainWindow, QVBoxLayout, QWidget)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c

# program modules 
from database import Database
from ui_target_areas_window import Ui_TargetAreasWindow
import workouts_window as ww
import exercises_window as ew

class TargetAreasWindow(QMainWindow, Ui_TargetAreasWindow):

    def __init__(self, parent=None, database=None):
        super(QMainWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.target_areas_list_view.setModel(self.db.target_areas_model)
        self.target_areas_list_view.setModelColumn(1)

    @pyqtSignature("bool")
    def on_workouts_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'workouts'
        workouts_window = ww.WorkoutsWindow(self.parent(), self.db)
        workouts_window.show()
        self.hide()

    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()
