#include "mainwindow.h"
#include "ui_mainwindow.h"




MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

}

MainWindow::~MainWindow()
{
    delete ui;
}



void MainWindow::writeSettings() {
    /* Save postion/size of main window */
    QString qsname = QFileDialog::getSaveFileName(this, tr("Save File"),"/home/user/MyDocs/maecountfile.ini",tr("Ini File (*.ini)"));
    QSettings settings(qsname, QSettings::IniFormat);

   // QSettings settings("MaeCount", "MaeCount");
    settings.setValue("label1", ui->label_6->text());
    settings.setValue("label2", ui->label_7->text());
    settings.setValue("label3", ui->label_8->text());
    settings.setValue("label4", ui->label_9->text());
    settings.setValue("max1", ui->spinBox->value());
    settings.setValue("max2", ui->spinBox_2->value());
    settings.setValue("max3", ui->spinBox_4->value());
    settings.setValue("max4", ui->spinBox_3->value());
    settings.setValue("counter1", ui->counterOneButton->text());
    settings.setValue("counter2", ui->counterTwoButton->text());
    settings.setValue("counter3", ui->counterThreeButton->text());
    settings.setValue("counter4", ui->counterFourButton->text());
}

void MainWindow::readSettings() {
    QString qsname = QFileDialog::getOpenFileName(this, tr("Load File"),"/home/user/MyDocs/maecountfile.ini",tr("Ini File (*.ini)"));
    QSettings settings(qsname, QSettings::IniFormat);

    QString label1 = settings.value("label1").toString();
    QString label2 = settings.value("label2").toString();
    QString label3 = settings.value("label3").toString();
    QString label4 = settings.value("label4").toString();

    QString max1 = settings.value("max1").toString();
    QString max2 = settings.value("max2").toString();
    QString max3 = settings.value("max3").toString();
    QString max4 = settings.value("max4").toString();

    QString counter1 = settings.value("counter1").toString();
    QString counter2 = settings.value("counter2").toString();
    QString counter3 = settings.value("counter3").toString();
    QString counter4 = settings.value("counter4").toString();

    ui->label_6->setText(label1);
    ui->label_7->setText(label2);
    ui->label_8->setText(label3);
    ui->label_9->setText(label4);
    ui->spinBox->setValue(max1.toInt());
    ui->spinBox_2->setValue(max2.toInt());
    ui->spinBox_4->setValue(max3.toInt());
    ui->spinBox_3->setValue(max4.toInt());
    ui->counterOneButton->setText(counter1);
    ui->counterTwoButton->setText(counter2);
    ui->counterThreeButton->setText(counter3);
    ui->counterFourButton->setText(counter4);


    qDebug() << label1 << " - " << label2 << " - " << label3 << " - " << label4;
    qDebug() << max1 << " - " << max2 << " - " << max3 << " - " << max4;
}




void MainWindow::on_buttonLoad_clicked()
{
    readSettings();
}

void MainWindow::on_buttonSave_clicked()
{
  writeSettings();
}

void MainWindow::on_buttonNew_clicked()
{
    ui->label_6->setText("0");
    ui->label_7->setText("0");
    ui->label_8->setText("0");
    ui->label_9->setText("0");
    ui->spinBox->setValue(0);
    ui->spinBox_2->setValue(0);
    ui->spinBox_4->setValue(0);
    ui->spinBox_3->setValue(0);
    ui->counterOneButton->setText("Counter 1");
    ui->counterTwoButton->setText("Counter 2");
    ui->counterThreeButton->setText("Counter 3");
    ui->counterFourButton->setText("Counter 4");

}

void MainWindow::on_buttonPlusAll_clicked()
{
    int c1val = ui->label_6->text().toInt();
    c1val ++;
    if (c1val == ui->spinBox->value()){
    ui->label_6->setText("0");
}
    else{
    ui->label_6->setText(QString("%1").arg(c1val));

    }

    int c2val = ui->label_7->text().toInt();
    c2val ++;
    if (c2val == ui->spinBox_2->value()){
    ui->label_7->setText("0");
}
    else{
    ui->label_7->setText(QString("%1").arg(c2val));

    }

    int c3val = ui->label_8->text().toInt();
    c3val ++;
    if (c3val == ui->spinBox_4->value()){
    ui->label_8->setText("0");
}
    else{
    ui->label_8->setText(QString("%1").arg(c3val));

    }

    int c4val = ui->label_9->text().toInt();
    c4val ++;
    if (c4val == ui->spinBox_3->value()){
    ui->label_9->setText("0");
}
    else{
    ui->label_9->setText(QString("%1").arg(c4val));

    }




}

void MainWindow::on_counterOneButton_clicked()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("Please enter your new label name"),
                                         tr("New name:"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty())
        ui->counterOneButton->setText(text);
}

void MainWindow::on_counterTwoButton_clicked()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("Please enter your new label name"),
                                         tr("New name:"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty())
        ui->counterTwoButton->setText(text);
}

void MainWindow::on_counterThreeButton_clicked()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("Please enter your new label name"),
                                         tr("New name:"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty())
        ui->counterThreeButton->setText(text);
}

void MainWindow::on_counterFourButton_clicked()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("Please enter your new label name"),
                                         tr("New name:"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty())
        ui->counterFourButton->setText(text);
}

void MainWindow::on_pushButton_clicked()
{
    QMessageBox msgBox;
    msgBox.setText("Welcome to MaeCount \nMaecount is a simple multiple counter with various uses. \n \nTap each counter name/label to change it's name. \nThe numbers with a coloured background are your counters. \nThe numbers below the counters represent the maximum value the counter can count to. \nTap the large + button to increment all counters. \n\n Greg Roberts - me@Greg-Roberts.com - 2010");
    msgBox.exec();
}
