#include "noteeditor.h"
#include "dialognoteedit.h"
#include <QSqlQuery>
#include <calendar-backend/CMulticalendar.h>
#include <QVariant>

#include <iostream>
using namespace std;

NoteEditor::NoteEditor(QObject *parent) :
    QObject(parent)
{
}

bool NoteEditor::editJournal(int ComponentId){
    editJournal(ComponentId, 0);
}

bool NoteEditor::editJournal(int ComponentId, int FolderId){
    bool ok = true;

    //launch editor and load the contents
    DialogNoteEdit d;

    if(ComponentId > 0){ //update
        d.setComponentId(ComponentId);
        d.loadComponent(); //TODO should really be boolean or give status somehow
    }

    if(FolderId > 0 ){
        cout << "000000000000000000000000000";
        d.setFolderId(FolderId);
    }

    d.setWindowState(d.windowState() ^ Qt::WindowMaximized);

    if(d.exec()){
        cout <<"dialog confirmed!" << endl;

        //get all values and save
        bool ok = d.saveJournal();
        if(!ok){
            cout << "couldn't save TODO!" << endl;
        }

    } else {
        if(d.getDeleted()){
            cout << "dialog says deleted" << endl;
            deleteJournal(ComponentId, d.getCalendarId());
        } else {
            cout << "dialog canceled" << endl;
        }
    }

    return ok;
}


bool NoteEditor::addJournal(){
    editJournal(0); //new
    return true;    //ugly
}

bool NoteEditor::addJournal(int FolderId){
    editJournal(0,FolderId);   //add a brand new task to a folder
}

bool NoteEditor::deleteJournal(int ComponentId, int CalendarId){

//is it okay to do it this way or does the API do other things?

    //was in a  rush, no time to test for sure
    int error_code;
    CMulticalendar::MCInstance()->deleteTodo(CalendarId,
                QString::number(ComponentId).toLocal8Bit().constData(),error_code);
    cout << "ERROR CODE ON DELETE IS:" << error_code << endl;

    QSqlQuery q1;
    q1.prepare("DELETE FROM FolderItem WHERE id=?");
    q1.addBindValue(QVariant(ComponentId));
    q1.exec();



    return true; //ugly
}

